﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#include <nn/svc/svc_DdId.autogen.h>


//-------------------------------------------------
// Result CreateSharedMemory(nn::svc::Handle* pOut, size_t size, nn::svc::MemoryPermission myPermission, nn::svc::MemoryPermission otherPermission)
//
//     AArch64 s=8 r=8 p=8                  Invariant s=8 r=8 p=8
// in  abi                                  svc
//     Register 0  ref  4 pOut              
//     Register 1       8 size              Register 1       8 size
//     Register 2       4 myPermission      Register 2       4 myPermission
//     Register 3       4 otherPermission   Register 3       4 otherPermission
//
// out abi                                  svc
//     Register 0       4 return            Register 0       4 return
//                                          Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch644lp6418CreateSharedMemoryEPNS0_6HandleEmNS0_16MemoryPermissionES5_, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp6418CreateSharedMemoryEPNS0_6HandleEmNS0_16MemoryPermissionES5_
    .hidden  _ZN2nn3svc7aarch644lp6418CreateSharedMemoryEPNS0_6HandleEmNS0_16MemoryPermissionES5_
    .type    _ZN2nn3svc7aarch644lp6418CreateSharedMemoryEPNS0_6HandleEmNS0_16MemoryPermissionES5_, %function
_ZN2nn3svc7aarch644lp6418CreateSharedMemoryEPNS0_6HandleEmNS0_16MemoryPermissionES5_:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_CREATE_SHARED_MEMORY

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch644lp6418CreateSharedMemoryEPNS0_6HandleEmNS0_16MemoryPermissionES5_, [.-_ZN2nn3svc7aarch644lp6418CreateSharedMemoryEPNS0_6HandleEmNS0_16MemoryPermissionES5_]


//-------------------------------------------------
// Result MapTransferMemory(nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission ownerPermission)
//
//     AArch64 s=8 r=8 p=8                  Invariant s=8 r=8 p=8
// in  abi                                  svc
//     Register 0       4 handle            Register 0       4 handle
//     Register 1       8 addr              Register 1       8 addr
//     Register 2       8 size              Register 2       8 size
//     Register 3       4 ownerPermission   Register 3       4 ownerPermission
//
// out abi                                  svc
//     Register 0       4 return            Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp6417MapTransferMemoryENS0_6HandleEmmNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp6417MapTransferMemoryENS0_6HandleEmmNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch644lp6417MapTransferMemoryENS0_6HandleEmmNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch644lp6417MapTransferMemoryENS0_6HandleEmmNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch644lp6417MapTransferMemoryENS0_6HandleEmmNS0_16MemoryPermissionE:

    svc      #NN_SVC_ID_MAP_TRANSFER_MEMORY
    ret

    .size _ZN2nn3svc7aarch644lp6417MapTransferMemoryENS0_6HandleEmmNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch644lp6417MapTransferMemoryENS0_6HandleEmmNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result UnmapTransferMemory(nn::svc::Handle handle, uintptr_t addr, size_t size)
//
//     AArch64 s=8 r=8 p=8         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 handle   Register 0       4 handle
//     Register 1       8 addr     Register 1       8 addr
//     Register 2       8 size     Register 2       8 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp6419UnmapTransferMemoryENS0_6HandleEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp6419UnmapTransferMemoryENS0_6HandleEmm
    .hidden  _ZN2nn3svc7aarch644lp6419UnmapTransferMemoryENS0_6HandleEmm
    .type    _ZN2nn3svc7aarch644lp6419UnmapTransferMemoryENS0_6HandleEmm, %function
_ZN2nn3svc7aarch644lp6419UnmapTransferMemoryENS0_6HandleEmm:

    svc      #NN_SVC_ID_UNMAP_TRANSFER_MEMORY
    ret

    .size _ZN2nn3svc7aarch644lp6419UnmapTransferMemoryENS0_6HandleEmm, [.-_ZN2nn3svc7aarch644lp6419UnmapTransferMemoryENS0_6HandleEmm]


//-------------------------------------------------
// Result CreateInterruptEvent(nn::svc::Handle* pReadHandle, int32_t name, nn::svc::InterruptType type)
//
//     AArch64 s=8 r=8 p=8              Invariant s=8 r=8 p=8
// in  abi                              svc
//     Register 0  ref  4 pReadHandle   
//     Register 1       4 name          Register 1       4 name
//     Register 2       4 type          Register 2       4 type
//
// out abi                              svc
//     Register 0       4 return        Register 0       4 return
//                                      Register 1       4 pReadHandle
//
// conversion
//   Scatter         pReadHandle

    .section .text._ZN2nn3svc7aarch644lp6420CreateInterruptEventEPNS0_6HandleEiNS0_13InterruptTypeE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp6420CreateInterruptEventEPNS0_6HandleEiNS0_13InterruptTypeE
    .hidden  _ZN2nn3svc7aarch644lp6420CreateInterruptEventEPNS0_6HandleEiNS0_13InterruptTypeE
    .type    _ZN2nn3svc7aarch644lp6420CreateInterruptEventEPNS0_6HandleEiNS0_13InterruptTypeE, %function
_ZN2nn3svc7aarch644lp6420CreateInterruptEventEPNS0_6HandleEiNS0_13InterruptTypeE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_CREATE_INTERRUPT_EVENT

    ldr      x2, [sp, #0]              // pReadHandleのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pReadHandle の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch644lp6420CreateInterruptEventEPNS0_6HandleEiNS0_13InterruptTypeE, [.-_ZN2nn3svc7aarch644lp6420CreateInterruptEventEPNS0_6HandleEiNS0_13InterruptTypeE]


//-------------------------------------------------
// Result QueryPhysicalAddress(nn::svc::lp64::PhysicalMemoryInfo* pBlockInfo, uintptr_t addr)
//
//     AArch64 s=8 r=8 p=8             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0  ref 24 pBlockInfo   
//     Register 1       8 addr         Register 1       8 addr
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//                                     Register 1      24 pBlockInfo
//                                     Register 2      24 pBlockInfo
//                                     Register 3      24 pBlockInfo
//
// conversion
//   Scatter         pBlockInfo

    .section .text._ZN2nn3svc7aarch644lp6420QueryPhysicalAddressEPNS0_4lp6418PhysicalMemoryInfoEm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp6420QueryPhysicalAddressEPNS0_4lp6418PhysicalMemoryInfoEm
    .hidden  _ZN2nn3svc7aarch644lp6420QueryPhysicalAddressEPNS0_4lp6418PhysicalMemoryInfoEm
    .type    _ZN2nn3svc7aarch644lp6420QueryPhysicalAddressEPNS0_4lp6418PhysicalMemoryInfoEm, %function
_ZN2nn3svc7aarch644lp6420QueryPhysicalAddressEPNS0_4lp6418PhysicalMemoryInfoEm:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_QUERY_PHYSICAL_ADDRESS

    ldr      x4, [sp, #0]              // pBlockInfoのアドレス をスタックからレジスタへ
    str      x1, [x4, #0]              // pBlockInfo の第 1 ワードをレジスタからメモリへ
    str      x2, [x4, #8]              // pBlockInfo の第 2 ワードをレジスタからメモリへ
    str      x3, [x4, #16]             // pBlockInfo の第 3 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch644lp6420QueryPhysicalAddressEPNS0_4lp6418PhysicalMemoryInfoEm, [.-_ZN2nn3svc7aarch644lp6420QueryPhysicalAddressEPNS0_4lp6418PhysicalMemoryInfoEm]


//-------------------------------------------------
// Result QueryIoMapping(uintptr_t* pOut, nn::svc::PhysicalAddress physicalAddress, size_t size)
//
//     AArch64 s=8 r=8 p=8                  Invariant s=8 r=8 p=8
// in  abi                                  svc
//     Register 0  ref  8 pOut              
//     Register 1       8 physicalAddress   Register 1       8 physicalAddress
//     Register 2       8 size              Register 2       8 size
//
// out abi                                  svc
//     Register 0       4 return            Register 0       4 return
//                                          Register 1       8 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch644lp6414QueryIoMappingEPmmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp6414QueryIoMappingEPmmm
    .hidden  _ZN2nn3svc7aarch644lp6414QueryIoMappingEPmmm
    .type    _ZN2nn3svc7aarch644lp6414QueryIoMappingEPmmm, %function
_ZN2nn3svc7aarch644lp6414QueryIoMappingEPmmm:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_QUERY_IO_MAPPING

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      x1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch644lp6414QueryIoMappingEPmmm, [.-_ZN2nn3svc7aarch644lp6414QueryIoMappingEPmmm]


//-------------------------------------------------
// Result CreateDeviceAddressSpace(nn::svc::Handle* pOut, uint64_t spaceAddress, uint64_t spaceSize)
//
//     AArch64 s=8 r=8 p=8               Invariant s=8 r=8 p=8
// in  abi                               svc
//     Register 0  ref  4 pOut           
//     Register 1       8 spaceAddress   Register 1       8 spaceAddress
//     Register 2       8 spaceSize      Register 2       8 spaceSize
//
// out abi                               svc
//     Register 0       4 return         Register 0       4 return
//                                       Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch644lp6424CreateDeviceAddressSpaceEPNS0_6HandleEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp6424CreateDeviceAddressSpaceEPNS0_6HandleEmm
    .hidden  _ZN2nn3svc7aarch644lp6424CreateDeviceAddressSpaceEPNS0_6HandleEmm
    .type    _ZN2nn3svc7aarch644lp6424CreateDeviceAddressSpaceEPNS0_6HandleEmm, %function
_ZN2nn3svc7aarch644lp6424CreateDeviceAddressSpaceEPNS0_6HandleEmm:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_CREATE_DEVICE_ADDRESS_SPACE

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch644lp6424CreateDeviceAddressSpaceEPNS0_6HandleEmm, [.-_ZN2nn3svc7aarch644lp6424CreateDeviceAddressSpaceEPNS0_6HandleEmm]


//-------------------------------------------------
// Result AttachDeviceAddressSpace(nn::svc::DeviceName deviceName, nn::svc::Handle handle)
//
//     AArch64 s=8 r=8 p=8             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0       4 deviceName   Register 0       4 deviceName
//     Register 1       4 handle       Register 1       4 handle
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp6424AttachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp6424AttachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch644lp6424AttachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE
    .type    _ZN2nn3svc7aarch644lp6424AttachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE, %function
_ZN2nn3svc7aarch644lp6424AttachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE:

    svc      #NN_SVC_ID_ATTACH_DEVICE_ADDRESS_SPACE
    ret

    .size _ZN2nn3svc7aarch644lp6424AttachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE, [.-_ZN2nn3svc7aarch644lp6424AttachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE]


//-------------------------------------------------
// Result DetachDeviceAddressSpace(nn::svc::DeviceName deviceName, nn::svc::Handle handle)
//
//     AArch64 s=8 r=8 p=8             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0       4 deviceName   Register 0       4 deviceName
//     Register 1       4 handle       Register 1       4 handle
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp6424DetachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp6424DetachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch644lp6424DetachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE
    .type    _ZN2nn3svc7aarch644lp6424DetachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE, %function
_ZN2nn3svc7aarch644lp6424DetachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE:

    svc      #NN_SVC_ID_DETACH_DEVICE_ADDRESS_SPACE
    ret

    .size _ZN2nn3svc7aarch644lp6424DetachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE, [.-_ZN2nn3svc7aarch644lp6424DetachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE]


//-------------------------------------------------
// Result MapDeviceAddressSpaceByForce(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission)
//
//     AArch64 s=8 r=8 p=8                   Invariant s=8 r=8 p=8
// in  abi                                   svc
//     Register 0       4 addressSpace       Register 0       4 addressSpace
//     Register 1       4 process            Register 1       4 process
//     Register 2       8 processAddress     Register 2       8 processAddress
//     Register 3       8 size               Register 3       8 size
//     Register 4       8 deviceAddress      Register 4       8 deviceAddress
//     Register 5       4 devicePermission   Register 5       4 devicePermission
//
// out abi                                   svc
//     Register 0       4 return             Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp6428MapDeviceAddressSpaceByForceENS0_6HandleES3_mmmNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp6428MapDeviceAddressSpaceByForceENS0_6HandleES3_mmmNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch644lp6428MapDeviceAddressSpaceByForceENS0_6HandleES3_mmmNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch644lp6428MapDeviceAddressSpaceByForceENS0_6HandleES3_mmmNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch644lp6428MapDeviceAddressSpaceByForceENS0_6HandleES3_mmmNS0_16MemoryPermissionE:

    svc      #NN_SVC_ID_MAP_DEVICE_ADDRESS_SPACE_BY_FORCE
    ret

    .size _ZN2nn3svc7aarch644lp6428MapDeviceAddressSpaceByForceENS0_6HandleES3_mmmNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch644lp6428MapDeviceAddressSpaceByForceENS0_6HandleES3_mmmNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result MapDeviceAddressSpaceAligned(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission)
//
//     AArch64 s=8 r=8 p=8                   Invariant s=8 r=8 p=8
// in  abi                                   svc
//     Register 0       4 addressSpace       Register 0       4 addressSpace
//     Register 1       4 process            Register 1       4 process
//     Register 2       8 processAddress     Register 2       8 processAddress
//     Register 3       8 size               Register 3       8 size
//     Register 4       8 deviceAddress      Register 4       8 deviceAddress
//     Register 5       4 devicePermission   Register 5       4 devicePermission
//
// out abi                                   svc
//     Register 0       4 return             Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp6428MapDeviceAddressSpaceAlignedENS0_6HandleES3_mmmNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp6428MapDeviceAddressSpaceAlignedENS0_6HandleES3_mmmNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch644lp6428MapDeviceAddressSpaceAlignedENS0_6HandleES3_mmmNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch644lp6428MapDeviceAddressSpaceAlignedENS0_6HandleES3_mmmNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch644lp6428MapDeviceAddressSpaceAlignedENS0_6HandleES3_mmmNS0_16MemoryPermissionE:

    svc      #NN_SVC_ID_MAP_DEVICE_ADDRESS_SPACE_ALIGNED
    ret

    .size _ZN2nn3svc7aarch644lp6428MapDeviceAddressSpaceAlignedENS0_6HandleES3_mmmNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch644lp6428MapDeviceAddressSpaceAlignedENS0_6HandleES3_mmmNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result MapDeviceAddressSpace(size_t* pMappedSize, nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission)
//
//     AArch64 s=8 r=8 p=8                   Invariant s=8 r=8 p=8
// in  abi                                   svc
//     Register 0  ref  8 pMappedSize        
//     Register 1       4 addressSpace       Register 1       4 addressSpace
//     Register 2       4 process            Register 2       4 process
//     Register 3       8 processAddress     Register 3       8 processAddress
//     Register 4       8 size               Register 4       8 size
//     Register 5       8 deviceAddress      Register 5       8 deviceAddress
//     Register 6       4 devicePermission   Register 6       4 devicePermission
//
// out abi                                   svc
//     Register 0       4 return             Register 0       4 return
//                                           Register 1       8 pMappedSize
//
// conversion
//   Scatter         pMappedSize

    .section .text._ZN2nn3svc7aarch644lp6421MapDeviceAddressSpaceEPmNS0_6HandleES4_mmmNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp6421MapDeviceAddressSpaceEPmNS0_6HandleES4_mmmNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch644lp6421MapDeviceAddressSpaceEPmNS0_6HandleES4_mmmNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch644lp6421MapDeviceAddressSpaceEPmNS0_6HandleES4_mmmNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch644lp6421MapDeviceAddressSpaceEPmNS0_6HandleES4_mmmNS0_16MemoryPermissionE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_MAP_DEVICE_ADDRESS_SPACE

    ldr      x2, [sp, #0]              // pMappedSizeのアドレス をスタックからレジスタへ
    str      x1, [x2, #0]              // pMappedSize の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch644lp6421MapDeviceAddressSpaceEPmNS0_6HandleES4_mmmNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch644lp6421MapDeviceAddressSpaceEPmNS0_6HandleES4_mmmNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result UnmapDeviceAddressSpace(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress)
//
//     AArch64 s=8 r=8 p=8                 Invariant s=8 r=8 p=8
// in  abi                                 svc
//     Register 0       4 addressSpace     Register 0       4 addressSpace
//     Register 1       4 process          Register 1       4 process
//     Register 2       8 processAddress   Register 2       8 processAddress
//     Register 3       8 size             Register 3       8 size
//     Register 4       8 deviceAddress    Register 4       8 deviceAddress
//
// out abi                                 svc
//     Register 0       4 return           Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp6423UnmapDeviceAddressSpaceENS0_6HandleES3_mmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp6423UnmapDeviceAddressSpaceENS0_6HandleES3_mmm
    .hidden  _ZN2nn3svc7aarch644lp6423UnmapDeviceAddressSpaceENS0_6HandleES3_mmm
    .type    _ZN2nn3svc7aarch644lp6423UnmapDeviceAddressSpaceENS0_6HandleES3_mmm, %function
_ZN2nn3svc7aarch644lp6423UnmapDeviceAddressSpaceENS0_6HandleES3_mmm:

    svc      #NN_SVC_ID_UNMAP_DEVICE_ADDRESS_SPACE
    ret

    .size _ZN2nn3svc7aarch644lp6423UnmapDeviceAddressSpaceENS0_6HandleES3_mmm, [.-_ZN2nn3svc7aarch644lp6423UnmapDeviceAddressSpaceENS0_6HandleES3_mmm]


//-------------------------------------------------
// Result InvalidateProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size)
//
//     AArch64 s=8 r=8 p=8          Invariant s=8 r=8 p=8
// in  abi                          svc
//     Register 0       4 process   Register 0       4 process
//     Register 1       8 addr      Register 1       8 addr
//     Register 2       8 size      Register 2       8 size
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp6426InvalidateProcessDataCacheENS0_6HandleEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp6426InvalidateProcessDataCacheENS0_6HandleEmm
    .hidden  _ZN2nn3svc7aarch644lp6426InvalidateProcessDataCacheENS0_6HandleEmm
    .type    _ZN2nn3svc7aarch644lp6426InvalidateProcessDataCacheENS0_6HandleEmm, %function
_ZN2nn3svc7aarch644lp6426InvalidateProcessDataCacheENS0_6HandleEmm:

    svc      #NN_SVC_ID_INVALIDATE_PROCESS_DATA_CACHE
    ret

    .size _ZN2nn3svc7aarch644lp6426InvalidateProcessDataCacheENS0_6HandleEmm, [.-_ZN2nn3svc7aarch644lp6426InvalidateProcessDataCacheENS0_6HandleEmm]


//-------------------------------------------------
// Result StoreProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size)
//
//     AArch64 s=8 r=8 p=8          Invariant s=8 r=8 p=8
// in  abi                          svc
//     Register 0       4 process   Register 0       4 process
//     Register 1       8 addr      Register 1       8 addr
//     Register 2       8 size      Register 2       8 size
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp6421StoreProcessDataCacheENS0_6HandleEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp6421StoreProcessDataCacheENS0_6HandleEmm
    .hidden  _ZN2nn3svc7aarch644lp6421StoreProcessDataCacheENS0_6HandleEmm
    .type    _ZN2nn3svc7aarch644lp6421StoreProcessDataCacheENS0_6HandleEmm, %function
_ZN2nn3svc7aarch644lp6421StoreProcessDataCacheENS0_6HandleEmm:

    svc      #NN_SVC_ID_STORE_PROCESS_DATA_CACHE
    ret

    .size _ZN2nn3svc7aarch644lp6421StoreProcessDataCacheENS0_6HandleEmm, [.-_ZN2nn3svc7aarch644lp6421StoreProcessDataCacheENS0_6HandleEmm]


//-------------------------------------------------
// Result FlushProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size)
//
//     AArch64 s=8 r=8 p=8          Invariant s=8 r=8 p=8
// in  abi                          svc
//     Register 0       4 process   Register 0       4 process
//     Register 1       8 addr      Register 1       8 addr
//     Register 2       8 size      Register 2       8 size
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch644lp6421FlushProcessDataCacheENS0_6HandleEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch644lp6421FlushProcessDataCacheENS0_6HandleEmm
    .hidden  _ZN2nn3svc7aarch644lp6421FlushProcessDataCacheENS0_6HandleEmm
    .type    _ZN2nn3svc7aarch644lp6421FlushProcessDataCacheENS0_6HandleEmm, %function
_ZN2nn3svc7aarch644lp6421FlushProcessDataCacheENS0_6HandleEmm:

    svc      #NN_SVC_ID_FLUSH_PROCESS_DATA_CACHE
    ret

    .size _ZN2nn3svc7aarch644lp6421FlushProcessDataCacheENS0_6HandleEmm, [.-_ZN2nn3svc7aarch644lp6421FlushProcessDataCacheENS0_6HandleEmm]


    .end

