﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdarg>
#include <nn/os.h>
#include <nn/os/os_Macro.h>
#include <nn/socket/socket_Api.h>
#include <nnc/nn_Result.h>
#include <nnc/result/result_CConverter.h>
#include <nn/socket/socket_ApiPrivate.h>
#include <nnc/socket/socket_ApiPrivate.h>

NN_OS_EXTERN_C ssize_t nnsocketRecv(int socket, void* outBuffer, size_t outBufferLength, int flags)
{
    return nn::socket::Recv(socket, outBuffer, outBufferLength, flags);
}

NN_OS_EXTERN_C ssize_t nnsocketRecvFrom(int socket, void* outBuffer, size_t outBufferLength, int flags, sockaddr* pOutAddress, socklen_t* pOutAddressLength)
{
    return nn::socket::RecvFrom(socket, outBuffer, outBufferLength, flags, pOutAddress, pOutAddressLength);
}

NN_OS_EXTERN_C ssize_t nnsocketSend(int socket, const void* buffer, size_t bufferLength, int flags)
{
    return nn::socket::Send(socket, buffer, bufferLength, flags);
}

NN_OS_EXTERN_C ssize_t nnsocketSendTo(int socket, const void* buffer, size_t bufferLength, int flags, const sockaddr* pAddress, socklen_t addressLength)
{
    return nn::socket::SendTo(socket, buffer, bufferLength, flags, pAddress, addressLength);
}

NN_OS_EXTERN_C int nnsocketAccept(int socket, sockaddr* pOutAddress, socklen_t* pOutAddressLength)
{
    return nn::socket::Accept(socket, pOutAddress, pOutAddressLength);
}

NN_OS_EXTERN_C int nnsocketBind(int socket, const sockaddr* pAddress, socklen_t addressLength)
{
    return nn::socket::Bind(socket, pAddress, addressLength);
}

NN_OS_EXTERN_C int nnsocketConnect(int socket, const sockaddr* pAddress, socklen_t addressLength)
{
    return nn::socket::Connect(socket, pAddress, addressLength);
}

NN_OS_EXTERN_C int nnsocketGetPeerName(int socket, sockaddr* pOutAddress, socklen_t* pOutAddressLength)
{
    return nn::socket::GetPeerName(socket, pOutAddress, pOutAddressLength);
}

NN_OS_EXTERN_C int nnsocketGetSockName(int socket, sockaddr* pOutAddress, socklen_t* pOutAddressLength)
{
    return nn::socket::GetSockName(socket, pOutAddress, pOutAddressLength);
}

NN_OS_EXTERN_C int nnsocketGetSockOpt(int socket, int level, int optionName, void* pOutOptionValue, socklen_t* pOutOptionLength)
{
    return nn::socket::GetSockOpt(socket, level, optionName, pOutOptionValue, pOutOptionLength);
}

NN_OS_EXTERN_C int nnsocketListen(int socket, int backlog)
{
    return nn::socket::Listen(socket, backlog);
}

NN_OS_EXTERN_C int nnsocketSetSockOpt(int socket, int level, int optionName, const void* pOptionValue, socklen_t optionLength)
{
    return nn::socket::SetSockOpt(socket, level, optionName, pOptionValue, optionLength);
}

NN_OS_EXTERN_C int nnsocketSockAtMark(int socket)
{
    return nn::socket::SockAtMark(socket);
}

NN_OS_EXTERN_C int nnsocketShutdown(int socket, int how)
{
    return nn::socket::Shutdown(socket, how);
}

NN_OS_EXTERN_C int nnsocketSocket(int domain, int type, int protocol)
{
    return nn::socket::Socket(domain, type, protocol);
}

NN_OS_EXTERN_C int nnsocketWrite(int socket, const void* buffer, size_t bufferLength)
{
    return nn::socket::Write(socket, buffer, bufferLength);
}

NN_OS_EXTERN_C int nnsocketRead(int socket, void* outBuffer, size_t outBufferLength)
{
    return nn::socket::Read(socket, outBuffer, outBufferLength);
}

NN_OS_EXTERN_C int nnsocketClose(int socket)
{
    return nn::socket::Close(socket);
}

NN_OS_EXTERN_C int nnsocketSelect(int numberOfDescriptors, fd_set*  pReadDescriptors, fd_set*  pWriteDescriptors, fd_set*  pExceptDescriptors, timeval* pTimeout)
{
    return nn::socket::Select(numberOfDescriptors, pReadDescriptors, pWriteDescriptors, pExceptDescriptors, pTimeout);
}

NN_OS_EXTERN_C int nnsocketPoll(pollfd* pSocketDescriptors, nfds_t numberOfDescriptors, int timeoutMilliseconds)
{
    return nn::socket::Poll(pSocketDescriptors, numberOfDescriptors, timeoutMilliseconds);
}

NN_OS_EXTERN_C int nnsocketFcntl(int socket, int command, ...)
{
    int iocmd;
    va_list args;
    va_start(args, command);
    iocmd = va_arg(args, int);
    va_end(args);
    return nn::socket::Fcntl(socket, command, iocmd);
}

NN_OS_EXTERN_C int nnsocketInetPton(int family, const char* pAddressString, void* pOutAddressBuffer)
{
    return nn::socket::InetPton(family, pAddressString, pOutAddressBuffer);
}

NN_OS_EXTERN_C const char* nnsocketInetNtop(int family, const void* pNetworkAddress, char* addressStringBuffer, socklen_t addressStringBufferLength)
{
    return nn::socket::InetNtop(family, pNetworkAddress, addressStringBuffer, addressStringBufferLength);
}

NN_OS_EXTERN_C int nnsocketInetAton(const char* addressStringBuffer, in_addr* pOutNetworkAddress)
{
    return nn::socket::InetAton(addressStringBuffer, pOutNetworkAddress);
}

NN_OS_EXTERN_C char* nnsocketInetNtoa(in_addr networkAddress)
{
    return nn::socket::InetNtoa(networkAddress);
}

NN_OS_EXTERN_C uint16_t nnsocketInetHtons(uint16_t hostValue)
{
    return nn::socket::InetHtons(hostValue);
}

NN_OS_EXTERN_C uint32_t nnsocketInetHtonl(uint32_t hostValue)
{
    return nn::socket::InetHtonl(hostValue);
}

NN_OS_EXTERN_C uint16_t nnsocketInetNtohs(uint16_t networkValue)
{
    return nn::socket::InetNtohs(networkValue);
}

NN_OS_EXTERN_C uint32_t nnsocketInetNtohl(uint32_t networkValue)
{
    return nn::socket::InetNtohl(networkValue);
}

NN_OS_EXTERN_C int nnsocketGetLastErrno()
{
    return nn::socket::GetLastErrno();
}

NN_OS_EXTERN_C void nnsocketSetLastErrno(int error)
{
    nn::socket::SetLastErrno(error);
}

NN_OS_EXTERN_C ssize_t nnsocketRecvMsg(int socket, msghdr* pOutMessage, int flags)
{
    return nn::socket::RecvMsg(socket, pOutMessage, flags);
}

NN_OS_EXTERN_C ssize_t nnsocketSendMsg(int socket, const msghdr* pMessage, int flags)
{
    return nn::socket::SendMsg(socket, pMessage, flags);
}

NN_OS_EXTERN_C int nnsocketIoctl(int socket, uint32_t command, void* pData, size_t dataLength)
{
    return nn::socket::Ioctl(socket, command, pData, dataLength);
}

NN_OS_EXTERN_C int nnsocketOpen(const char* path, int flags)
{
    return nn::socket::Open(path, flags);
}

NN_OS_EXTERN_C nnResult nnsocketInitialize(void* memoryPool, size_t memoryPoolSize, size_t allocatorPoolSize, int concurrencyLimit)
{
    return nn::result::ConvertToC(nn::socket::Initialize(memoryPool, memoryPoolSize, allocatorPoolSize, concurrencyLimit));
}

NN_OS_EXTERN_C nnResult nnsocketFinalize()
{
    nnResult result = nn::result::ConvertToC(nn::socket::Finalize());

    return result;
}

NN_OS_EXTERN_C int nnsocketGetAddrInfo(const char* pNodeName, const char* pServerName, const addrinfo* pHints, addrinfo** pResult)
{
    return nn::socket::GetAddrInfo(pNodeName, pServerName, pHints, pResult, NULL, 0);
}

NN_OS_EXTERN_C int nnsocketGetAddrInfoWithOptions(const char* pNodeName, const char* pServerName, const addrinfo* pHints, addrinfo** pResult, const struct nnsocketResolverOption* options, size_t optionCount)
{
    return nn::socket::GetAddrInfo(pNodeName, pServerName, pHints, pResult, reinterpret_cast<const nn::socket::ResolverOption*>(options), optionCount);
}

NN_OS_EXTERN_C hostent* nnsocketGetHostByName(const char* pName)
{
    return nn::socket::GetHostByName(pName, NULL, 0);
}

NN_OS_EXTERN_C hostent* nnsocketGetHostByNameWithOptions(const char* pName, const struct nnsocketResolverOption* options, size_t optionCount)
{
    return nn::socket::GetHostByName(pName, reinterpret_cast<const nn::socket::ResolverOption*>(options), optionCount);
}

NN_OS_EXTERN_C hostent* nnsocketGetHostByAddr(const void* pAddress, socklen_t length, int addressFamily)
{
    return nn::socket::GetHostByAddr(pAddress, length, addressFamily, NULL, 0);
}

NN_OS_EXTERN_C hostent* nnsocketGetHostByAddrWithOptions(const void* pAddress, socklen_t length, int addressFamily, const struct nnsocketResolverOption* options, size_t optionCount)
{
    return nn::socket::GetHostByAddr(pAddress, length, addressFamily, reinterpret_cast<const nn::socket::ResolverOption*>(options), optionCount);
}

NN_OS_EXTERN_C int nnsocketGetNameInfo(const sockaddr* socketAddress, socklen_t socketAddressLength, char* host, socklen_t hostLength, char* service, socklen_t serviceLength, int flags)
{
    return nn::socket::GetNameInfo(socketAddress, socketAddressLength, host, hostLength, service, serviceLength, flags, NULL, 0);
}

NN_OS_EXTERN_C int nnsocketGetNameInfoWithOptions(const sockaddr* socketAddress, socklen_t socketAddressLength, char* host, socklen_t hostLength, char* service, socklen_t serviceLength, int flags, const struct nnsocketResolverOption* options, size_t optionCount)
{
    return nn::socket::GetNameInfo(socketAddress, socketAddressLength, host, hostLength, service, serviceLength, flags, reinterpret_cast<const nn::socket::ResolverOption*>(options), optionCount);
}

NN_OS_EXTERN_C void nnsocketFreeAddrInfo(addrinfo* addrInfoStorage)
{
    nn::socket::FreeAddrInfo(addrInfoStorage);
}

NN_OS_EXTERN_C int* nnsocketGetHErrno()
{
    return nn::socket::GetHErrno();
}

NN_OS_EXTERN_C const char* nnsocketHStrError(int errorNumber)
{
    return nn::socket::HStrError(errorNumber);
}

NN_OS_EXTERN_C int nnsocketResolverGetOption(nnsocketResolverOption* pOut,
                                             nnsocketResolverOptionKey keyIn)
{
    if (NULL == pOut)
    {
        errno = EINVAL;
        return -1;
    };

    nn::socket::ResolverOptionKey key = static_cast<nn::socket::ResolverOptionKey>(keyIn);

    nn::socket::ResolverOption* pOptionOut = reinterpret_cast<nn::socket::ResolverOption*>(pOut);

    return nn::socket::ResolverGetOption(pOptionOut, key);
};

NN_OS_EXTERN_C int nnsocketResolverSetOption(const nnsocketResolverOption* pIn)
{
    if (NULL == pIn)
    {
        errno = EINVAL;
        return -1;
    };

    const nn::socket::ResolverOption* pOptionIn = reinterpret_cast<const nn::socket::ResolverOption*>(pIn);

    return nn::socket::ResolverSetOption(*pOptionIn);
};

NN_OS_EXTERN_C const char* nnsocketGAIStrError(int errorCode)
{
    return nn::socket::GAIStrError(errorCode);
}

NN_OS_EXTERN_C int nnsocketSysctl(int* pMibEntries, size_t mibEntryCount, void* pOldValue, size_t* pOldValueLength, void* pNewValue, size_t newValueLength)
{
    return nn::socket::Sysctl(pMibEntries, mibEntryCount, pOldValue, pOldValueLength, pNewValue, newValueLength);
}

NN_OS_EXTERN_C int nnsocketDuplicateSocket(int socket, uint64_t ownerProcessId)
{
    return nn::socket::DuplicateSocket(socket, ownerProcessId);
}

NN_OS_EXTERN_C int GetResourceStatistics(nn::socket::StatisticsType type, void* outBuffer, size_t outBufferLength, uint32_t options)
{
    return nn::socket::GetResourceStatistics(type, outBuffer, outBufferLength, options);
}
