﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "serializer.h"

#include <nn/socket/socket_Api.h>

//#define LOG_LEVEL LOG_LEVEL_MAJOR
#define LOG_MODULE_NAME "serializer" // NOLINT(preprocessor/const)
#include <nn/socket/resolver/private/resolver_DebugLog.h>

namespace nn { namespace socket { namespace resolver { namespace serializer {

// basic checks
ssize_t DNSSerializer::CheckToBufferArguments(const uint8_t * pBuffer,
                                              size_t sizeOfBuffer,
                                              size_t sizeNeeded,
                                              int errorNumber)
{
    int rc = -1;

    if ( NULL == pBuffer )
    {
        LogMajor("error: pBuffer is NULL (%d)\n", errorNumber);
        goto bail;
    }
    else if (sizeOfBuffer < sizeNeeded )
    {
        LogMajor("error: pBufferOut is too small (%d) (available=%d, needed=%d)\n",
                 errorNumber,
                 sizeOfBuffer,
                 sizeNeeded);
        goto bail;
    };

    rc = 0;

bail:
    return rc;
}

uint32_t DNSSerializer::InternalHton(const uint32_t& value)
{
    return nn::socket::InetHtonl(value);
}

uint16_t DNSSerializer::InternalHton(const uint16_t& value)
{
    return nn::socket::InetHtons(value);
}

uint32_t DNSSerializer::InternalNtoh(const uint32_t& value)
{
    return nn::socket::InetNtohl(value);
}

uint16_t DNSSerializer::InternalNtoh(const uint16_t& value)
{
    return nn::socket::InetNtohs(value);
}

}}}} // namespace nn::socket::resolver::serializer
