﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sm/sm_ManagerApi.h>
#include <nn/sm/detail/sm_ManagerInterface.h>

#include <nn/svc/svc_Handle.h>

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ExpHeapAllocator.h>


namespace nn { namespace sm {

    namespace
    {
        struct AllocatorTag
        {
        };

        typedef nn::sf::ExpHeapStaticAllocator<1024, AllocatorTag> MyAllocator;

        nn::sf::SharedPointer<nn::sm::detail::IManagerInterface> g_RefInterface;
        bool g_IsInitialized = false;
    }

    Result InitializeForManager() NN_NOEXCEPT
    {
        NN_SDK_ASSERT( ! g_IsInitialized );

        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);

        Result result = nn::sf::CreateHipcProxyByName<nn::sm::detail::IManagerInterface, MyAllocator::Policy>(
            &g_RefInterface, nn::sm::detail::PortNameForManager);
        if( result.IsSuccess() )
        {
            g_IsInitialized = true;
        }

        return result;
    }

    Result FinalizeForManager() NN_NOEXCEPT
    {
        NN_ABORT("not implemented");
        return ResultSuccess();
    }

    Result RegisterProcess(os::ProcessId id,
        const void* pAccessRightsLimit, size_t limitSize,
        const void* pAccessRights,      size_t rightsSize ) NN_NOEXCEPT
    {
        auto inLimit = nn::sf::InBuffer(reinterpret_cast<const char*>(pAccessRightsLimit), limitSize);
        auto inRights = nn::sf::InBuffer(reinterpret_cast<const char*>(pAccessRights), rightsSize);
        return g_RefInterface->RegisterProcess(id, inLimit, inRights);
    }

    Result UnregisterProcess(os::ProcessId id) NN_NOEXCEPT
    {
        return g_RefInterface->UnregisterProcess(id);
    }

}}  // namespace nn::sm
