﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/os/os_MultipleWaitTypes.h>
#include <utility>

#include "sf_HipcEmulatedPort.h"


namespace nn { namespace sf { namespace hipc {

class HipcEmulatedInProcessPort;
class HipcEmulatedClientSession;
class HipcEmulatedServerSession;

class HipcEmulatedInProcessClientPort
    : public HipcEmulatedClientPort
{
private:

    SharedPointer<HipcEmulatedInProcessPort> m_Port;

protected:

    explicit HipcEmulatedInProcessClientPort(HipcEmulatedInProcessPort* port) NN_NOEXCEPT;
    ~HipcEmulatedInProcessClientPort() NN_NOEXCEPT;

public:

    virtual void AttachConnectEvent(nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT NN_OVERRIDE;
    virtual HipcEmulatedClientSession* Connect(bool blocking) NN_NOEXCEPT NN_OVERRIDE;

};

class HipcEmulatedInProcessServerPort
    : public HipcEmulatedServerPort
{
private:

    SharedPointer<HipcEmulatedInProcessPort> m_Port;

protected:

    explicit HipcEmulatedInProcessServerPort(HipcEmulatedInProcessPort* port) NN_NOEXCEPT;
    ~HipcEmulatedInProcessServerPort() NN_NOEXCEPT;

public:

    virtual void AttachAcceptEvent(nn::os::MultiWaitHolderType* pHolder) NN_NOEXCEPT NN_OVERRIDE;
    virtual void WaitAccept() NN_NOEXCEPT NN_OVERRIDE;
    virtual HipcEmulatedServerSession* Accept() NN_NOEXCEPT NN_OVERRIDE;

};

std::pair<
    HipcEmulatedInProcessServerPort*,
    HipcEmulatedInProcessClientPort*
> CreateHipcEmulatedInProcessPortPair(int maxSessions) NN_NOEXCEPT;

}}}
