﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>

#include "sf_HipcWindowsThreadpoolWork.h"


namespace nn { namespace sf { namespace hipc { namespace detail {

void HipcWindowsThreadpoolWork::WorkCallback(PTP_CALLBACK_INSTANCE pInstance, PVOID pContext, PTP_WORK pThreadpoolWork) NN_NOEXCEPT
{
    reinterpret_cast<HipcWindowsThreadpoolWork*>(pContext)->WorkCallbackImpl(pInstance, pThreadpoolWork);
}

void HipcWindowsThreadpoolWork::WorkCallbackImpl(PTP_CALLBACK_INSTANCE pInstance, PTP_WORK pThreadpoolWork) NN_NOEXCEPT
{
    NN_UNUSED(pThreadpoolWork);
    NN_SDK_ASSERT(pThreadpoolWork == m_pThreadpoolWork);

    RunThreadpoolWork(pInstance);
}

HipcWindowsThreadpoolWork::HipcWindowsThreadpoolWork() NN_NOEXCEPT
{
    m_pThreadpoolWork = ::CreateThreadpoolWork(WorkCallback, this, NULL);
    NN_ABORT_UNLESS(m_pThreadpoolWork != NULL, "CreateThreadpoolWork failed with an unexpected error %lu", ::GetLastError());
}

HipcWindowsThreadpoolWork::~HipcWindowsThreadpoolWork() NN_NOEXCEPT
{
    ::CloseThreadpoolWork(m_pThreadpoolWork);
}

void HipcWindowsThreadpoolWork::SubmitThreadpoolWork() NN_NOEXCEPT
{
    ::SubmitThreadpoolWork(m_pThreadpoolWork);
}

void HipcWindowsThreadpoolWork::WaitForThreadpoolWork(bool cancelPendingCallbacks) NN_NOEXCEPT
{
    ::WaitForThreadpoolWorkCallbacks(m_pThreadpoolWork, cancelPendingCallbacks);
}

}}}}
