﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/hipc/client/sf_HipcClientSessionManager.h>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/sf/hipc/client/sf_HipcManagerAccessor.h>

namespace nn { namespace sf { namespace hipc { namespace client {

Result HipcClientSessionManager::ConvertToDomainImpl(cmif::CmifDomainObjectId* pOut, HipcClientSessionHandle handle) NN_NOEXCEPT
{
    uint16_t pointerBufferSize;
    NN_RESULT_DO(QueryPointerBufferSize(&pointerBufferSize, handle));
    this->SetPointerBufferSize(pointerBufferSize);
    return ConvertSessionToDomain(pOut, handle);
}

Result HipcClientSessionManager::CreateNewSession(HipcClientSessionHandle* pOut) NN_NOEXCEPT
{
    auto clientHandle = this->Allocate();
    NN_UTIL_SCOPE_EXIT
    {
        this->Deallocate(clientHandle);
    };
    return DuplicateSession(pOut, clientHandle);
}

}}}}
