﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/cmif/sf_InlineContext.h>
#include <nn/sf/sf_FsInlineContext.h>

#include <nn/os/os_SdkThreadApi.h>
#include <cstring>

namespace nn { namespace sf {

namespace cmif {

static_assert(sizeof(InlineContext) <= sizeof(os::SdkGetInternalTlsRegion()->sfInlineContext), "");

InlineContext GetInlineContext() NN_NOEXCEPT
{
    auto p = &os::SdkGetInternalTlsRegion()->sfInlineContext;
    InlineContext ret;
    std::memcpy(&ret, p, sizeof(ret));
    return ret;
}

InlineContext SetInlineContext(InlineContext x) NN_NOEXCEPT
{
    auto p = &os::SdkGetInternalTlsRegion()->sfInlineContext;
    InlineContext ret;
    std::memcpy(&ret, p, sizeof(ret));
    std::memcpy(p, &x, sizeof(x));
    return ret;
}

} // namespace cmif

Bit8 GetFsInlineContext() NN_NOEXCEPT
{
    auto p = &os::SdkGetInternalTlsRegion()->sfInlineContext;
    Bit8 ret;
    std::memcpy(&ret, p, sizeof(ret));
    return ret;
}

Bit8 SetFsInlineContext(Bit8 x) NN_NOEXCEPT
{
    auto p = &os::SdkGetInternalTlsRegion()->sfInlineContext;
    Bit8 ret;
    std::memcpy(&ret, p, sizeof(ret));
    std::memcpy(p, &x, sizeof(x));
    return ret;
}

}}
