﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "sdmmc_BaseDeviceAccessor.h"

namespace nn { namespace sdmmc {
namespace detail {

class GcAsicDevice : public BaseDevice
{
private:
    #if (defined(NN_DETAIL_SDMMC_USE_NN_OS_FOR_EVENT))
        mutable nn::os::EventType m_RemovedEvent;
    #endif
    const uint16_t Rca = 0; // Argument は 0 固定のため

public:
    #if (defined(NN_DETAIL_SDMMC_USE_NN_OS_FOR_EVENT))
        virtual nn::os::EventType* GetRemovedEvent() const NN_NOEXCEPT NN_OVERRIDE
        {
            return &m_RemovedEvent;
        }
    #endif

    virtual DeviceType GetDeviceType() const NN_NOEXCEPT NN_OVERRIDE
    {
        return DeviceType_GcAsic;
    }

    virtual uint16_t GetRca() const NN_NOEXCEPT NN_OVERRIDE
    {
        return Rca;
    }
};

class GcAsicDeviceAccessor : public BaseDeviceAccessor
{
private:
    GcAsicDevice m_GcAsicDevice;
    bool m_IsInitialized;

    Result IssueCommandWriteOperation(const void* pOperationBuffer, size_t operationBufferSize) const NN_NOEXCEPT;
    Result IssueCommandFinishOperation() const NN_NOEXCEPT;
    Result IssueCommandSleep() const NN_NOEXCEPT;
    Result IssueCommandUpdateKey() const NN_NOEXCEPT;
    Result StartupGcAsicDevice() NN_NOEXCEPT;

protected:
    virtual Result OnActivate() NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnReadWrite(uint32_t sectorIndex, uint32_t numSectors, void* pBuffer, size_t bufferSize, bool isRead) NN_NOEXCEPT NN_OVERRIDE;

    virtual Result ReStartup() NN_NOEXCEPT NN_OVERRIDE
    {
        NN_ABORT("GcAsicDeviceAccessor dosen't support re-startup\n");
        return ResultNotSupported();
    }

public:
    explicit GcAsicDeviceAccessor(IHostController* pHostController) NN_NOEXCEPT
        : BaseDeviceAccessor(pHostController)
    {
        m_IsInitialized = false;
    }

    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;
    virtual Result GetSpeedMode(SpeedMode* pOutSpeedMode) const NN_NOEXCEPT NN_OVERRIDE;
    void PutGcAsicToSleep() NN_NOEXCEPT;
    Result AwakenGcAsic() NN_NOEXCEPT;
    Result WriteGcAsicOperation(const void* pOperationBuffer, size_t operationBufferSize) NN_NOEXCEPT;
    Result FinishGcAsicOperation() NN_NOEXCEPT;
    Result AbortGcAsicOperation() NN_NOEXCEPT;
    Result SleepGcAsic() NN_NOEXCEPT;
    Result UpdateGcAsicKey() NN_NOEXCEPT;

    void SignalGcRemovedEvent() NN_NOEXCEPT
    {
        #if (defined(NN_DETAIL_SDMMC_USE_NN_OS_FOR_EVENT))
            m_GcAsicDevice.SignalRemovedEvent();
        #else
            NN_ABORT("NN_DETAIL_SDMMC_USE_NN_OS_FOR_EVENT isn't defined.\n");
        #endif
    }

    void ClearGcRemovedEvent() NN_NOEXCEPT
    {
        #if (defined(NN_DETAIL_SDMMC_USE_NN_OS_FOR_EVENT))
            m_GcAsicDevice.ClearRemovedEvent();
        #else
            NN_ABORT("NN_DETAIL_SDMMC_USE_NN_OS_FOR_EVENT isn't defined.\n");
        #endif
    }
};

} // namespace detail {
}} // namespace nn { namespace sdmmc {
