﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.ro
{
    namespace detail
    {
        public interface IRoInterface : IServiceObject
        {
            [MethodId(0)]
            Result
                MapManualLoadModuleMemory(
                    Out<uint64_t>           pOut,
                    [ProcessId] nn.Bit64    pid,
                    uint64_t                imageAddress,
                    uint64_t                imageSize,
                    uint64_t                bufferAddress,
                    uint64_t                bufferSize
                );

            [MethodId(1)]
            Result
                UnmapManualLoadModuleMemory(
                    [ProcessId] nn.Bit64    pid,
                    uint64_t                imageAddress
                );

            [MethodId(2)]
            Result
                RegisterModuleInfo(
                    [ProcessId] nn.Bit64    pid,
                    uint64_t                imageAddress,
                    uint64_t                imageSize
                );

            [MethodId(3)]
            Result
                UnregisterModuleInfo(
                    [ProcessId] nn.Bit64    pid,
                    uint64_t                imageAddress
                );

            [MethodId(4)]
            Result
                RegisterProcessHandle(
                    [ProcessId] nn.Bit64    pid,
                    NativeHandle            process
                );

        }
    }
}
