﻿/*---------------------------------------------------------------------------*
  Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>
#include <nn/TargetConfigs/build_Fpu.h>

#ifndef NN_BUILD_CONFIG_FPU_NUM_DOUBLE_REGISTERS
#error not define NN_BUILD_CONFIG_FPU_NUM_DOUBLE_REGISTERS
#endif

    .section .text, "ax"
    .align   2
    .global  _ZN2nn2ro9BindEntryEv
    .type    _ZN2nn2ro9BindEntryEv, %function
_ZN2nn2ro9BindEntryEv:
    // 既に lr は save済み
    // ip = &got[n + 3]
    // lr = &got[2]

    push    {r0 - r4}
    vpush   {d0 - d7}

    sub     r1, ip, lr
    sub     r1, r1, #4
    lsr     r1, r1, #2
    ldr     r0, [lr, #-4]
    mov     r4, ip

    bl      _ZN2nn2ro6detail4BindEPNS1_8RoModuleEj

    str     r0, [r4]
    mov     ip, r0
    vpop    {d0 - d7}
    pop     {r0 - r4, lr}
    bx      ip

    .size   _ZN2nn2ro9BindEntryEv, [. - _ZN2nn2ro9BindEntryEv]

