﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.os
{
    [CppRefPath(@"<nn/os/os_Types.h>")]
    public struct ProcessId
    {
        public nn.Bit64 value;
    }
}

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_ProgramId.h>")]
    [ExternalStruct(8, 8)]
    public struct ProgramId
    {
    }

    [CppRefPath(@"<nn/ncm/ncm_ProgramLocation.h>")]
    [ExternalStruct(16, 8)]
    public struct ProgramLocation
    {
    }
}

namespace nn.pm
{
    [CppRefPath(@"<nn/pm/pm_ShellApi.h>")]
    public struct ProcessEventInfo
    {
        public int32_t              event_;
        public nn.os.ProcessId      processId;
    }
}

namespace nn.pm.detail
{
    public interface IShellInterface : IServiceObject
    {
        [MethodId(0)]
        Result
            LaunchProgram(
                Out<nn.os.ProcessId>    pOut,
                nn.ncm.ProgramLocation  location,
                int32_t                 flags
            );

        [MethodId(1)]
        Result
            TerminateProcess(
                nn.os.ProcessId         id
            );

        [MethodId(2)]
        Result
            TerminateProgram(
                nn.ncm.ProgramId         id
            );

        [MethodId(3)]
        Result
            GetProcessEventHandle(
                Out<NativeHandle>       handle
            );

        [MethodId(4)]
        Result
            GetProcessEventInfo(
                Out<nn.pm.ProcessEventInfo>   pOut
            );

        [MethodId(5)]
        Result
            NotifyBootFinished(
            );

        [MethodId(6)]
        Result
            GetApplicationProcessIdForShell(
                Out<nn.os.ProcessId>    pOut
            );

        [MethodId(7)]
        Result
            BoostSystemMemoryResourceLimit(
                int64_t boostSize
            );
    }
}
