﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pm/pm_DebugMonitorApi.h>
#include <nn/pm/detail/pm_DebugMonitorInterface.h>

#include <nn/svc/svc_Handle.h>

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ExpHeapAllocator.h>


namespace nn { namespace pm {

    namespace
    {
        struct AllocatorTag
        {
        };

        typedef nn::sf::ExpHeapStaticAllocator<1024, AllocatorTag> MyAllocator;

        nn::sf::SharedPointer<nn::pm::detail::IDebugMonitorInterface> g_RefDebugMonitorInterface;
        bool g_IsInitialized = false;
    }

    Result InitializeForDebugMonitor() NN_NOEXCEPT
    {
        NN_SDK_ASSERT( ! g_IsInitialized );

        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);

        Result result = nn::sf::CreateHipcProxyByName<nn::pm::detail::IDebugMonitorInterface, MyAllocator::Policy>(
            &g_RefDebugMonitorInterface, nn::pm::detail::PortNameForDebugMonitor);
        if( result.IsSuccess() )
        {
            g_IsInitialized = true;
        }

        return result;
    }

    Result FinalizeForProcessManager() NN_NOEXCEPT
    {
        NN_ABORT("not implemented");
        return ResultSuccess();
    }

    Result GetExceptionProcessIdList(int* pStoredCount, os::ProcessId* pBuffer, int bufferEntryCount) NN_NOEXCEPT
    {
        auto ob = sf::OutBuffer(reinterpret_cast<char*>(pBuffer), sizeof(*pBuffer) * bufferEntryCount);
        return g_RefDebugMonitorInterface->GetExceptionProcessIdList(pStoredCount, ob);
    }

    Result StartProcess(os::ProcessId id) NN_NOEXCEPT
    {
        return g_RefDebugMonitorInterface->StartProcess(id);
    }

    Result GetProcessId(os::ProcessId* pOut, ncm::ProgramId programId) NN_NOEXCEPT
    {
        return g_RefDebugMonitorInterface->GetProcessId(pOut, programId);
    }

    Result GetApplicationProcessId(os::ProcessId* pOut) NN_NOEXCEPT
    {
        return g_RefDebugMonitorInterface->GetApplicationProcessId(pOut);
    }

    Result HookToCreateProcess(os::NativeHandle* pOut, ncm::ProgramId programId) NN_NOEXCEPT
    {
        sf::NativeHandle handle;
        auto ret = g_RefDebugMonitorInterface->HookToCreateProcess(&handle, programId);
        *pOut = handle.GetOsHandle();
        handle.Detach();
        return ret;
    }

    Result HookToCreateApplicationProcess(os::NativeHandle* pOut) NN_NOEXCEPT
    {
        sf::NativeHandle handle;
        auto ret = g_RefDebugMonitorInterface->HookToCreateApplicationProcess(&handle);
        *pOut = handle.GetOsHandle();
        handle.Detach();
        return ret;
    }

    Result ClearHook(int hookTypes) NN_NOEXCEPT
    {
        return g_RefDebugMonitorInterface->ClearHook(hookTypes);
    }

}}
