﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>

#include <nn/os/os_Macro.h>
#include <nn/os/os_TimerEventTypes.h>
#include <nn/os/os_TimerEventApi.h>

#include <nnc/os/os_Macro.h>
#include <nnc/os/os_TimerEventTypes.h>
#include <nnc/os/os_TimerEventApi.h>

#include "detail/os_Diag.h"
#include "detail/os_Common.h"

//---------------------------------------------------------------------------
//  C++ 用の型とサイズやアライメントが一致しているのかをチェック
//---------------------------------------------------------------------------

static_assert(sizeof(nnosTimerEventType) == sizeof(nn::os::TimerEventType), "");
static_assert(NN_ALIGNOF(nnosTimerEventType) == NN_ALIGNOF(nn::os::TimerEventType), "");

static_assert(static_cast<int>(nnosEventClearMode_ManualClear) == static_cast<int>(nn::os::EventClearMode_ManualClear), "");
static_assert(static_cast<int>(nnosEventClearMode_AutoClear) == static_cast<int>(nn::os::EventClearMode_AutoClear), "");


//--------------------------------------------------------------------------
//  C 関数の定義
//--------------------------------------------------------------------------

NN_OS_EXTERN_C void nnosInitializeTimerEvent(nnosTimerEventType* event, nnosEventClearMode clearMode)
{
    nn::os::InitializeTimerEvent(reinterpret_cast<nn::os::TimerEventType*>(event), static_cast<nn::os::EventClearMode>(clearMode));
}

NN_OS_EXTERN_C void nnosFinalizeTimerEvent(nnosTimerEventType* event)
{
    nn::os::FinalizeTimerEvent(reinterpret_cast<nn::os::TimerEventType*>(event));
}

NN_OS_EXTERN_C void nnosStartOneShotTimerEvent(nnosTimerEventType* event, int64_t first)
{
    nn::os::StartOneShotTimerEvent(
                        reinterpret_cast<nn::os::TimerEventType*>(event),
                        nn::TimeSpan::FromNanoSeconds(first));
}

NN_OS_EXTERN_C void nnosStartPeriodicTimerEvent(nnosTimerEventType* event, int64_t first, int64_t interval)
{
    nn::os::StartPeriodicTimerEvent(
                        reinterpret_cast<nn::os::TimerEventType*>(event),
                        nn::TimeSpan::FromNanoSeconds(first),
                        nn::TimeSpan::FromNanoSeconds(interval));
}

NN_OS_EXTERN_C void nnosStopTimerEvent(nnosTimerEventType* event)
{
    nn::os::StopTimerEvent(reinterpret_cast<nn::os::TimerEventType*>(event));
}

NN_OS_EXTERN_C void nnosSignalTimerEvent(nnosTimerEventType* event)
{
    nn::os::SignalTimerEvent(reinterpret_cast<nn::os::TimerEventType*>(event));
}

NN_OS_EXTERN_C void nnosClearTimerEvent(nnosTimerEventType* event)
{
    nn::os::ClearTimerEvent(reinterpret_cast<nn::os::TimerEventType*>(event));
}

NN_OS_EXTERN_C void nnosWaitTimerEvent(nnosTimerEventType* event)
{
    nn::os::WaitTimerEvent(reinterpret_cast<nn::os::TimerEventType*>(event));
}

NN_OS_EXTERN_C bool nnosTryWaitTimerEvent(nnosTimerEventType* event)
{
    return nn::os::TryWaitTimerEvent(reinterpret_cast<nn::os::TimerEventType*>(event));
}

NN_OS_EXTERN_C void nnosInitializeMultiWaitHolderForTimerEvent(nnosMultiWaitHolderType* multiWaitHolder, nnosTimerEventType* timerEvent)
{
    nn::os::InitializeMultiWaitHolder(reinterpret_cast<nn::os::MultiWaitHolderType*>(multiWaitHolder), reinterpret_cast<nn::os::TimerEventType*>(timerEvent));
}
