﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>

#include <nn/os/os_Macro.h>
#include <nn/os/os_SystemEventTypes.h>
#include <nn/os/os_SystemEventApi.h>

#include <nnc/result/result_CConverter.h>
#include <nnc/os/os_Macro.h>
#include <nnc/os/os_SystemEventTypes.h>
#include <nnc/os/os_SystemEventApi.h>

#include "detail/os_Diag.h"
#include "detail/os_Common.h"

//---------------------------------------------------------------------------
//  C++ 用の型とサイズやアライメントが一致しているのかをチェック
//---------------------------------------------------------------------------

static_assert(sizeof(nnosSystemEventType) == sizeof(nn::os::SystemEventType), "");
static_assert(NN_ALIGNOF(nnosSystemEventType) == NN_ALIGNOF(nn::os::SystemEventType), "");


//--------------------------------------------------------------------------
//  C 関数の定義
//--------------------------------------------------------------------------

NN_OS_EXTERN_C nnResult nnosCreateSystemEvent(nnosSystemEventType* event, nnosEventClearMode clearMode, bool interProcess)
{
    auto result = nn::os::CreateSystemEvent(reinterpret_cast<nn::os::SystemEventType*>(event), static_cast<nn::os::EventClearMode>(clearMode), interProcess);
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C void nnosAttachSystemEvent(nnosSystemEventType* event, nnosNativeHandle readableHandle, bool isReadableHandleManaged, nnosNativeHandle writableHandle, bool isWritableHandleManaged, nnosEventClearMode clearMode)
{
    nn::os::AttachSystemEvent(reinterpret_cast<nn::os::SystemEventType*>(event), static_cast<nn::os::NativeHandle>(readableHandle), isReadableHandleManaged, static_cast<nn::os::NativeHandle>(writableHandle), isWritableHandleManaged, static_cast<nn::os::EventClearMode>(clearMode));
}

NN_OS_EXTERN_C void nnosAttachReadableHandleToSystemEvent(nnosSystemEventType* event, nnosNativeHandle readableHandle, bool isReadableHandleManaged, nnosEventClearMode clearMode)
{
    nn::os::AttachReadableHandleToSystemEvent(reinterpret_cast<nn::os::SystemEventType*>(event), static_cast<nn::os::NativeHandle>(readableHandle), isReadableHandleManaged, static_cast<nn::os::EventClearMode>(clearMode));
}

NN_OS_EXTERN_C void nnosAttachWritableHandleToSystemEvent(nnosSystemEventType* event, nnosNativeHandle writableHandle, bool isWritableHandleManaged, nnosEventClearMode clearMode)
{
    nn::os::AttachWritableHandleToSystemEvent(reinterpret_cast<nn::os::SystemEventType*>(event), static_cast<nn::os::NativeHandle>(writableHandle), isWritableHandleManaged, static_cast<nn::os::EventClearMode>(clearMode));
}

NN_OS_EXTERN_C nnosNativeHandle nnosDetachReadableHandleOfSystemEvent(nnosSystemEventType* event)
{
    auto handle = nn::os::DetachReadableHandleOfSystemEvent(reinterpret_cast<nn::os::SystemEventType*>(event));
    return static_cast<nnosNativeHandle>(handle);
}

NN_OS_EXTERN_C nnosNativeHandle nnosDetachWritableHandleOfSystemEvent(nnosSystemEventType* event)
{
    auto handle = nn::os::DetachWritableHandleOfSystemEvent(reinterpret_cast<nn::os::SystemEventType*>(event));
    return static_cast<nnosNativeHandle>(handle);
}

NN_OS_EXTERN_C void nnosDestroySystemEvent(nnosSystemEventType* event)
{
    nn::os::DestroySystemEvent(reinterpret_cast<nn::os::SystemEventType*>(event));
}

NN_OS_EXTERN_C void nnosWaitSystemEvent(nnosSystemEventType* event)
{
    nn::os::WaitSystemEvent(reinterpret_cast<nn::os::SystemEventType*>(event));
}

NN_OS_EXTERN_C bool nnosTryWaitSystemEvent(nnosSystemEventType* event)
{
    return nn::os::TryWaitSystemEvent(reinterpret_cast<nn::os::SystemEventType*>(event));
}

NN_OS_EXTERN_C bool nnosTimedWaitSystemEvent(nnosSystemEventType* event, int64_t timeout)
{
    return nn::os::TimedWaitSystemEvent(reinterpret_cast<nn::os::SystemEventType*>(event), nn::TimeSpan::FromNanoSeconds(timeout));
}

NN_OS_EXTERN_C void nnosSignalSystemEvent(nnosSystemEventType* event)
{
    nn::os::SignalSystemEvent(reinterpret_cast<nn::os::SystemEventType*>(event));
}

NN_OS_EXTERN_C void nnosClearSystemEvent(nnosSystemEventType* event)
{
    nn::os::ClearSystemEvent(reinterpret_cast<nn::os::SystemEventType*>(event));
}

NN_OS_EXTERN_C nnosNativeHandle nnosGetReadableHandleOfSystemEvent(nnosSystemEventType* event)
{
    auto handle = nn::os::GetReadableHandleOfSystemEvent(reinterpret_cast<nn::os::SystemEventType*>(event));
    return static_cast<nnosNativeHandle>(handle);
}

NN_OS_EXTERN_C nnosNativeHandle nnosGetWritableHandleOfSystemEvent(nnosSystemEventType* event)
{
    auto handle = nn::os::GetWritableHandleOfSystemEvent(reinterpret_cast<nn::os::SystemEventType*>(event));
    return static_cast<nnosNativeHandle>(handle);
}

NN_OS_EXTERN_C void nnosInitializeMultiWaitHolderForSystemEvent(nnosMultiWaitHolderType* multiWaitHolder, nnosSystemEventType* event)
{
    nn::os::InitializeMultiWaitHolder(reinterpret_cast<nn::os::MultiWaitHolderType*>(multiWaitHolder), reinterpret_cast<nn::os::SystemEventType*>(event));
}
