﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_Config.h>
#include <nn/os/os_ThreadApi.h>
#include <nn/os/os_SdkRuntimeSupport.h>

#include "detail/os_RuntimeSupportImpl.h"

//-----------------------------------------------------------------------------

extern "C" void nnosNotifyDebugger(nnosNotificationReason reason, uintptr_t data, size_t size)
{
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    nn::os::detail::NotifyDebuggerImpl(reason, data, size);
#else
    NN_UNUSED(reason);
    NN_UNUSED(data);
    NN_UNUSED(size);
#endif
}

//-----------------------------------------------------------------------------

extern "C" NN_NORETURN void nnosBreak(nnosBreakReason reason, uintptr_t data, size_t size)
{
    nn::os::detail::BreakImpl(reason, data, size);
    for (;;)
    {
        nn::os::SleepThread( nn::TimeSpan::FromDays(1) );
    }
}

//-----------------------------------------------------------------------------

