﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>

#include <nn/os/os_Macro.h>
#include <nn/os/os_NativeHandleTypes.h>
#include <nn/os/os_NativeHandleApi.h>

#include <nnc/result/result_CConverter.h>
#include <nnc/os/os_Macro.h>
#include <nnc/os/os_NativeHandleTypes.h>
#include <nnc/os/os_NativeHandleApi.h>

#include "detail/os_Diag.h"
#include "detail/os_Common.h"

//---------------------------------------------------------------------------
//  C++ 用の型とサイズやアライメントが一致しているのかをチェック
//---------------------------------------------------------------------------

static_assert(sizeof(nnosNativeHandle) == sizeof(nn::os::NativeHandle), "");
static_assert(NN_ALIGNOF(nnosNativeHandle) == NN_ALIGNOF(nn::os::NativeHandle), "");


//--------------------------------------------------------------------------
//  C 関数の定義
//--------------------------------------------------------------------------

NN_OS_EXTERN_C void nnosCloseNativeHandle(nnosNativeHandle handle)
{
    nn::os::CloseNativeHandle(static_cast<nn::os::NativeHandle>(handle));
}
