﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Macro.h>

#include "os_TickManagerTypes.h"
#include "os_OsResourceManager.h"


namespace nn { namespace os {
namespace detail {

//---------------------------------------------------------------------------
// TickManager のインスタンスを取得する
inline TickManager* GetTickManagerInstance() NN_NOEXCEPT
{
    return &GetOsResourceManagerStorage()->tickManager;
}

//---------------------------------------------------------------------------
// 現在の Tick 値を取得する
inline Tick GetCurrentTick() NN_NOEXCEPT
{
    return detail::GetTickManagerInstance()->GetTick();
}

}  // namespace detail
}} // namespace nn::os

