﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "os_Common.h"
#include <nn/os/os_Config.h>

#if !defined(NN_BUILD_CONFIG_OS_SUPPORTS_WIN32)
    #error "OS 種別として Win32 が指定されていません。"
#endif

#include <nn/nn_Windows.h>
#include <cstdint>
#include <mmsystem.h>

#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_TickTypes.h>

#include "os_Diag.h"
#include "os_TickManager.h"

#pragma comment(lib, "winmm.lib")

namespace nn { namespace os {
namespace detail {

//---------------------------------------------------------------------------
//  C++ 関数の定義
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//  コンストラクタ
TickManagerImplByWin32::TickManagerImplByWin32() NN_NOEXCEPT
{
    // Windows の最小時間分解能を 1msec に設定
    ::timeBeginPeriod(1);

    // Windows の Tick 周期を取得
    LARGE_INTEGER   lpFrequency;
    QueryPerformanceFrequency( &lpFrequency );
    m_TickFrequency = static_cast<int64_t>( lpFrequency.QuadPart );
}

//---------------------------------------------------------------------------
//  デストラクタ
TickManagerImplByWin32::~TickManagerImplByWin32() NN_NOEXCEPT
{
    // Windows の最小時間分解能を元に戻す
    ::timeEndPeriod(1);
}

//---------------------------------------------------------------------------
//  Tick 値の獲得
Tick TickManagerImplByWin32::GetTick() const NN_NOEXCEPT
{
    // Win32 用の実装
    LARGE_INTEGER   lpCounter;

    QueryPerformanceCounter( &lpCounter );
    return  Tick( lpCounter.QuadPart );
}

}  // namespace detail
}} // namespace nn::os

