﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Windows.h>
#include <nn/result/result_HandlingUtility.h>

#include "os_RuntimeSupportImpl.h"

namespace nn { namespace os { namespace detail {

//-----------------------------------------------------------------------------

void BreakImpl(nnosBreakReason reason, uintptr_t data, size_t size) NN_NOEXCEPT
{
    NN_UNUSED(data);
    NN_UNUSED(size);

    switch (reason)
    {
    case nnosBreakReason_Panic:
    case nnosBreakReason_Assert:
        {
            ::DebugBreak();
        }
        break;

    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

//-----------------------------------------------------------------------------

}}} // namespace nn::os::detail

