﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include "os_RngManagerTypes.h"

//-----------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

uint64_t RngManager::GenerateRandomU64() NN_NOEXCEPT
{
    std::lock_guard<InternalCriticalSection> lock(m_CriticalSection);

    return m_Random.GenerateRandomU64();
}

}   // namespace detail
}}  // namespace nn::os
