﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Handle.h>
#include "os_RngManagerTypes.h"

//-----------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

RngManager::RngManager() NN_NOEXCEPT
{
    // 擬似乱数発生器を初期化
    Bit32 seed[4];

    // Kernel から 64bit の seed を 2 つ取得
    // 2, 3 はここで利用。0, 1 は一般公開用乱数 API で利用。
    svc::GetInfo(reinterpret_cast<Bit64*>(&seed[0]), svc::InfoType_Random, svc::INVALID_HANDLE_VALUE, 2);
    svc::GetInfo(reinterpret_cast<Bit64*>(&seed[2]), svc::InfoType_Random, svc::INVALID_HANDLE_VALUE, 3);

    m_Random.Initialize(seed, 4);
}

}   // namespace detail
}}  // namespace nn::os
