﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_TimerEventTypes.h>

#include "os_Common.h"
#include "os_TimerEventHelper.h"
#include "os_MultipleWaitHelper.h"
#include "os_MultipleWaitHolderBase.h"

//--------------------------------------------------------------------------

namespace nn { namespace os {

struct  TimerEventType;

namespace detail {

//--------------------------------------------------------------------------
//  TimerEventType 用の MultiWaitHolderBase 派生クラス
//
class MultiWaitHolderOfTimerEvent : public MultiWaitHolderOfUserWaitObject
{
public:
    explicit MultiWaitHolderOfTimerEvent(TimerEventType* p) NN_NOEXCEPT
                : m_TimerEvent( p ) {}

    virtual TriBool IsSignaled() const  NN_NOEXCEPT NN_OVERRIDE;
    virtual TriBool AddToObjectList() NN_NOEXCEPT NN_OVERRIDE;
    virtual void RemoveFromObjectList() NN_NOEXCEPT NN_OVERRIDE;
    virtual TimeSpan GetAbsoluteTimeToWakeup() const NN_NOEXCEPT NN_OVERRIDE;

private:
    TriBool IsSignaledUnsafe() const NN_NOEXCEPT
    {
        TimeSpan currTime = GetMultiWait()->GetCurrTime();
        UpdateSignalStateAndRecalcNextTimeToWakeupUnsafe(m_TimerEvent, currTime);
        return m_TimerEvent->_signalState ? TriBool::True : TriBool::False;
    }

private:
    TimerEventType* m_TimerEvent;       // 対象オブジェクトへのポインタ
};


}   // namespace detail
}}  // namespace nn::os

