﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os/os_ThreadTypes.h>

#include "os_Common.h"
#include "os_MultipleWaitHolderBase.h"

//--------------------------------------------------------------------------

namespace nn { namespace os {

struct  ThreadType;

namespace detail {

//--------------------------------------------------------------------------
//  ThreadType 用の MultiWaitHolderBase 派生クラス
//
class MultiWaitHolderOfThread : public MultiWaitHolderOfUserWaitObject
{
public:
    explicit MultiWaitHolderOfThread(ThreadType* p) NN_NOEXCEPT
                : m_Thread( p ) {}

    virtual TriBool IsSignaled() const  NN_NOEXCEPT NN_OVERRIDE;
    virtual TriBool AddToObjectList() NN_NOEXCEPT NN_OVERRIDE;
    virtual void RemoveFromObjectList() NN_NOEXCEPT NN_OVERRIDE;

private:
    TriBool IsSignaledUnsafe() const NN_NOEXCEPT
    {
        return m_Thread->_state == ThreadType::State_Exited ? TriBool::True : TriBool::False;
    }

private:
    ThreadType*   m_Thread;     // 対象オブジェクトへのポインタ
};


}   // namespace detail
}}  // namespace nn::os

