﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>

#include <nn/nn_Macro.h>
#include <nn/util/util_TypedStorage.h>
#include <nn/os/os_SemaphoreTypes.h>

#include "os_Common.h"
#include "os_MultipleWaitHelper.h"
#include "os_MultipleWaitHolderOfSemaphore.h"

//---------------------------------------------------------------------------
//  C++ 関数の定義
//---------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------
//  セマフォ用の多重待ちホルダーオブジェクト

// Semaphore オブジェクトの状態をポーリング
TriBool MultiWaitHolderOfSemaphore::IsSignaled() const NN_NOEXCEPT
{
    // クリティカルセクション
    std::lock_guard<InternalCriticalSection> lock( Get(m_Semaphore->_csSemaphore) );

    return this->IsSignaledUnsafe();
}

// 多重待ちオブジェクトを、SemaphoreType の多重待ちリストにリンク
TriBool MultiWaitHolderOfSemaphore::AddToObjectList() NN_NOEXCEPT
{
    // クリティカルセクション
    std::lock_guard<InternalCriticalSection> lock( Get(m_Semaphore->_csSemaphore) );

    Get( m_Semaphore->_multiWaitObjectList ).PushBackToList( *this );
    return this->IsSignaledUnsafe();
}

// 多重待ちオブジェクトを、SemaphoreType の多重待ちリストから外す
void MultiWaitHolderOfSemaphore::RemoveFromObjectList() NN_NOEXCEPT
{
    // クリティカルセクション
    std::lock_guard<InternalCriticalSection> lock( Get(m_Semaphore->_csSemaphore) );

    Get( m_Semaphore->_multiWaitObjectList ).EraseFromList( *this );
}


}   // namespace detail
}}  // namespace nn::os

