﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>

#include <nn/nn_Macro.h>
#include <nn/util/util_TypedStorage.h>
#include <nn/os/os_InterruptEventTypes.h>

#include "os_Common.h"
#include "os_InterruptEventImpl.h"
#include "os_MultipleWaitHelper.h"
#include "os_MultipleWaitHolderOfInterruptEvent.h"

//---------------------------------------------------------------------------
//  C++ 関数の定義
//---------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------
// InterruptEvent オブジェクトの状態をポーリング
TriBool MultiWaitHolderOfInterruptEvent::IsSignaled() const NN_NOEXCEPT
{
    return Get( m_InterruptEvent->_impl ).IsSignaled();
}

// カーネルのハンドルを返す
bool MultiWaitHolderOfInterruptEvent::GetNativeHandle(NativeHandle* pOut) const NN_NOEXCEPT
{
    *pOut = NativeHandle( Get( m_InterruptEvent->_impl ).GetHandle() );
    return true;
}


}   // namespace detail
}}  // namespace nn::os

