﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/util/util_TypedStorage.h>
#include <nn/os/os_Macro.h>
#include <nn/os/detail/os_MacroImpl.h>

#include "os_MultipleWaitHolderOfThread.h"
#include "os_MultipleWaitHolderOfSemaphore.h"
#include "os_MultipleWaitHolderOfEvent.h"
#include "os_MultipleWaitHolderOfTimerEvent.h"
#include "os_MultipleWaitHolderOfInterruptEvent.h"
#include "os_MultipleWaitHolderOfMessageQueue.h"
#include "os_MultipleWaitHolderOfInterProcessEvent.h"
#include "os_MultipleWaitHolderOfNativeHandle.h"

//--------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------
//  MultiWaitHolderType 構造体用の実際の大きさを定義するための構造体
//  公開ヘッダから TypedStorage するための定義

typedef util::TypedStorage< MultiWaitHolderOfThread,
                     sizeof(MultiWaitHolderOfThread),
                 NN_ALIGNOF(MultiWaitHolderOfThread) >
                            StorageForHolderOfThread;

NN_OS_DETAIL_STATIC_ASSERT_TRIVIALLY_DESTRUCTIBLE(MultiWaitHolderOfThread);

typedef util::TypedStorage< MultiWaitHolderOfSemaphore,
                     sizeof(MultiWaitHolderOfSemaphore),
                 NN_ALIGNOF(MultiWaitHolderOfSemaphore)>
                            StorageForHolderOfSemaphore;

NN_OS_DETAIL_STATIC_ASSERT_TRIVIALLY_DESTRUCTIBLE(MultiWaitHolderOfSemaphore);

typedef util::TypedStorage< MultiWaitHolderOfEvent,
                     sizeof(MultiWaitHolderOfEvent),
                 NN_ALIGNOF(MultiWaitHolderOfEvent) >
                            StorageForHolderOfEvent;

NN_OS_DETAIL_STATIC_ASSERT_TRIVIALLY_DESTRUCTIBLE(MultiWaitHolderOfEvent);

typedef util::TypedStorage< MultiWaitHolderOfTimerEvent,
                     sizeof(MultiWaitHolderOfTimerEvent),
                 NN_ALIGNOF(MultiWaitHolderOfTimerEvent) >
                            StorageForHolderOfTimerEvent;

NN_OS_DETAIL_STATIC_ASSERT_TRIVIALLY_DESTRUCTIBLE(MultiWaitHolderOfTimerEvent);

typedef util::TypedStorage< MultiWaitHolderOfInterruptEvent,
                     sizeof(MultiWaitHolderOfInterruptEvent),
                 NN_ALIGNOF(MultiWaitHolderOfInterruptEvent) >
                            StorageForHolderOfInterruptEvent;

NN_OS_DETAIL_STATIC_ASSERT_TRIVIALLY_DESTRUCTIBLE(MultiWaitHolderOfInterruptEvent);

typedef util::TypedStorage< MultiWaitHolderOfMessageQueueNotFull,
                     sizeof(MultiWaitHolderOfMessageQueueNotFull),
                 NN_ALIGNOF(MultiWaitHolderOfMessageQueueNotFull) >
                            StorageForHolderOfMessageQueueNotFull;

NN_OS_DETAIL_STATIC_ASSERT_TRIVIALLY_DESTRUCTIBLE(MultiWaitHolderOfMessageQueueNotFull);

typedef util::TypedStorage< MultiWaitHolderOfMessageQueueNotEmpty,
                     sizeof(MultiWaitHolderOfMessageQueueNotEmpty),
                 NN_ALIGNOF(MultiWaitHolderOfMessageQueueNotEmpty) >
                            StorageForHolderOfMessageQueueNotEmpty;

NN_OS_DETAIL_STATIC_ASSERT_TRIVIALLY_DESTRUCTIBLE(MultiWaitHolderOfMessageQueueNotEmpty);

typedef util::TypedStorage< MultiWaitHolderOfInterProcessEvent,
                     sizeof(MultiWaitHolderOfInterProcessEvent),
                 NN_ALIGNOF(MultiWaitHolderOfInterProcessEvent) >
                            StorageForHolderOfInterProcessEvent;

NN_OS_DETAIL_STATIC_ASSERT_TRIVIALLY_DESTRUCTIBLE(MultiWaitHolderOfInterProcessEvent);

typedef util::TypedStorage< MultiWaitHolderOfNativeHandle,
                     sizeof(MultiWaitHolderOfNativeHandle),
                 NN_ALIGNOF(MultiWaitHolderOfNativeHandle) >
                            StorageForHolderOfNativeHandle;

NN_OS_DETAIL_STATIC_ASSERT_TRIVIALLY_DESTRUCTIBLE(MultiWaitHolderOfNativeHandle);

struct MultiWaitHolderImpl
{
    union
    {
        StorageForHolderOfThread                holderOfThread;
        StorageForHolderOfSemaphore             holderOfSemaphore;
        StorageForHolderOfEvent                 holderOfEvent;
        StorageForHolderOfTimerEvent            holderOfTimerEvent;
        StorageForHolderOfInterruptEvent        holderOfInterruptEvent;
        StorageForHolderOfMessageQueueNotFull   holderOfMessageQueueNotFull;
        StorageForHolderOfMessageQueueNotEmpty  holderOfMessageQueueNotEmpty;
        StorageForHolderOfInterProcessEvent     holderOfInterProcessEvent;
        StorageForHolderOfNativeHandle          holderOfNativeHandle;
    };
};

NN_OS_DETAIL_STATIC_ASSERT_TRIVIAL(MultiWaitHolderImpl);
NN_OS_DETAIL_STATIC_ASSERT_TRIVIALLY_DESTRUCTIBLE(MultiWaitHolderImpl);

}   // namespace detail
}}  // namespace nn::os

