﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/os/detail/os_InternalCriticalSection.h>

#include <nn/svc/svc_Base.h>

//--------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------
//  MemoryHeapManagerImplByHorizon クラス
//
class MemoryHeapManagerImplByHorizon
{
public:
    Result SetHeapSize(uintptr_t* pOutAddress, size_t size)  NN_NOEXCEPT;
    size_t    GetReservedSize() const NN_NOEXCEPT
    {
        // TORIAEZU: 実機環境では呼ばれない想定
        NN_ABORT("");
        return 0;
    }

private:
    InternalCriticalSection m_criticalSection;
};

typedef MemoryHeapManagerImplByHorizon    MemoryHeapManagerImpl;

}   // namespace detail
}}  // namespace nn::os

