﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os/os_Config.h>

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os/os_MemoryHeapCommon.h>
#include <nn/result/result_HandlingUtility.h>

#include "os_Diag.h"
#include "os_Common.h"
#include "os_MemoryHeapManager.h"

#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_MemoryMapSelect.h>


//--------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

//----------------------------------------------------------------------------
// ヒープサイズの変更
Result MemoryHeapManagerImplByHorizon::SetHeapSize(uintptr_t* pOutAddress, size_t size) NN_NOEXCEPT
{
    auto result = svc::SetHeapSize(pOutAddress, size);
    NN_RESULT_TRY(result)
        NN_RESULT_CATCH( svc::ResultOutOfMemory )
        {
            NN_RESULT_THROW( os::ResultOutOfMemory() );
        }
        NN_RESULT_CATCH( svc::ResultLimit )
        {
            NN_RESULT_THROW( os::ResultOutOfMemory() );
        }
        NN_RESULT_CATCH( svc::ResultOutOfResource )
        {
            NN_RESULT_THROW( os::ResultOutOfMemory() );
        }
        NN_RESULT_CATCH_ALL
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS( result );
        }
    NN_RESULT_END_TRY
    NN_RESULT_SUCCESS;
}

//----------------------------------------------------------------------------

}   // namespace detail
}}  // namespace nn::os

