﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Windows.h>
#include <nn/nn_Macro.h>


namespace nn { namespace os { namespace detail {

//--------------------------------------------------------------------------
//  GiantLockForWin32 クラス
//
class GiantLockForWin32
{
    NN_DISALLOW_COPY( GiantLockForWin32 );
    NN_DISALLOW_MOVE( GiantLockForWin32 );

public:
    GiantLockForWin32()  NN_NOEXCEPT;
    ~GiantLockForWin32() NN_NOEXCEPT;

    void lock() NN_NOEXCEPT
    {
        ::WaitForSingleObject(m_MutexHandle, INFINITE);
    }
    void unlock() NN_NOEXCEPT
    {
        ::ReleaseMutex(m_MutexHandle);
    }

private:
    HANDLE  m_MutexHandle;
};

typedef GiantLockForWin32 GiantLock;

}}} // namespace nn::os::detail

