﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>
#include <nn/os/os_Config.h>
#include <nn/svc/svc_Base.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------

class DyingMessageImplByHorizon
{
public:
    static void SetRegion(uintptr_t address, size_t size) NN_NOEXCEPT
    {
        Bit64 processRegionAddress;

        NN_SDK_REQUIRES( address > 0 );
        NN_SDK_REQUIRES( address % nn::os::MemoryPageSize == 0 );
        NN_SDK_REQUIRES( size <= 4096 );

        // プロセス固有領域にダイイング・メッセージ領域を記憶
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::svc::GetInfo(&processRegionAddress, svc::InfoType_ProcessRegionAddress, svc::PSEUDO_HANDLE_CURRENT_PROCESS, 0));

        svc::ProcessLocalRegion* region = reinterpret_cast<svc::ProcessLocalRegion*>(processRegionAddress);
        region->dyingMessageRegionAddress = address;
        region->dyingMessageRegionSize = size;
    }
};

typedef DyingMessageImplByHorizon DyingMessageImpl;

//--------------------------------------------------------------------------

}  // namespace detail
}} // namespace nn::os

