﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#include <nn/os/os_Config.h>
#include <nn/os/os_UserExceptionHandler.h>

#if defined(NN_BUILD_CONFIG_OS_HORIZON)

extern "C" void* nnosGetDefaultUserExceptionStackForApplication(size_t* pOutSize) __attribute__((weak));

namespace nn { namespace os { namespace detail {

void PrintExceptionHeader(nn::os::UserExceptionInfo* info) NN_NOEXCEPT;
void PrintExceptionType(nn::os::UserExceptionInfo* info) NN_NOEXCEPT;
void PrintThreadInformation(nn::os::UserExceptionInfo* info, uintptr_t* outStackTop, uintptr_t* outStackBottom) NN_NOEXCEPT;
void PrintGeneralPurposeRegisters(nn::os::UserExceptionInfo* info) NN_NOEXCEPT;
void PrintSpecialRegisters(nn::os::UserExceptionInfo* info) NN_NOEXCEPT;
void PrintFloatingPointRegisters(nn::os::UserExceptionInfo* info) NN_NOEXCEPT;
void PrintStackTrace(nn::os::UserExceptionInfo* info) NN_NOEXCEPT;
void PrintStackDump(nn::os::UserExceptionInfo* info, uintptr_t stackTop, uintptr_t stackBottom) NN_NOEXCEPT;
void PrintMemoryInformation() NN_NOEXCEPT;

//-----------------------------------------------------------------------------

inline bool IsApplication() NN_NOEXCEPT
{
    return nnosGetDefaultUserExceptionStackForApplication != nullptr;
}

}}}  // namespace nn::os::detail

#endif

