﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/os/os_Types.h>
#include <nn/os/os_NativeHandleTypes.h>
#include <nn/os/os_DebugTypes.h>
#include <nn/os/os_TickTypes.h>
#include <nn/svc/svc_Base.h>

namespace nn { namespace os { namespace detail {

//---------------------------------------------------------------------------

class DebugImplByHorizon
{
public:
    static void GetCurrentStackInfo(uintptr_t* outStack, size_t* outStackSize) NN_NOEXCEPT;
    static void QueryMemoryInfo(MemoryInfo* info) NN_NOEXCEPT;

    static uintptr_t GetCurrentStackPointer() NN_NOEXCEPT
    {
        uintptr_t currentSp;
        asm volatile (" mov %0, sp" : "=&r"(currentSp) : : "memory" );
        return currentSp;
    }

    static Tick GetIdleTickCount() NN_NOEXCEPT
    {
        Bit64 value;
        auto result = svc::GetInfo( &value,
                                    svc::InfoType_IdleTickCount,
                                    svc::INVALID_HANDLE_VALUE,
                                    static_cast<Bit64>(-1) );
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);

        return Tick( static_cast<uint64_t>(value) );
    }
};

typedef DebugImplByHorizon   DebugImpl;

bool ExamineWholeAddressSpaceHasNoAttribute(uintptr_t address, size_t size) NN_NOEXCEPT;

//---------------------------------------------------------------------------

}}} // namespace nn::os::detail

