﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Macro.h>

//---------------------------------------------------------------------------
// 日本語以外の環境で表示される文字コードエンコーディングに関する警告の抑制
#pragma warning( disable : 4566 )


//---------------------------------------------------------------------------
// VS2015 で warning C4668 が出るのを抑制
#if defined(NN_BUILD_CONFIG_TOOLCHAIN_VC_VS2015) && \
    !defined(WINAPI_PARTITION_SYSTEM)
#define WINAPI_PARTITION_SYSTEM 0   // NOLINT(readability/define)
#endif

//---------------------------------------------------------------------------
//  マクロの定義
//---------------------------------------------------------------------------

namespace nn { namespace os {
namespace detail {

// OS-API 内部実装用 初期化ルーチン のセクションを構築
#pragma section(".CRT$XCD", read)

#define NN_OS_DETAIL_MAKE_EARLY_INITIALIZER_SYMBOL_(suffix)     \
        NN_MACRO_CONCATENATE(NN_MAKE_TEMPORARY_NAME(NN_MACRO_CONCATENATE(NN_MACRO_CONCATENATE(g_nnosDetailEarlyInitializer ## suffix ## _, __LINE__), _)), _)

#define NN_OS_DETAIL_ATTACH_EARLY_INITIALIZER(initFunction)                 \
        namespace {                                                         \
            __declspec(allocate(".CRT$XCD"))                                \
            void (* NN_OS_DETAIL_MAKE_EARLY_INITIALIZER_SYMBOL_(0) )() =    \
                                                            (initFunction); \
        }

}   // namespace detail
}}  // namespace nn::os



