﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>

#include <mutex>

namespace nn { namespace os { namespace detail {

#if defined(NN_BUILD_CONFIG_TOOLCHAIN_VC_VS2012) || \
    defined(NN_BUILD_CONFIG_TOOLCHAIN_VC_VS2013)
void CallOnceForFunctionLocalStaticImpl(int* pFlag, void (*f)(void* p), void* p) NN_NOEXCEPT
{
    static_assert(sizeof(*pFlag) >= sizeof(std::once_flag), "");
    auto& flag = *reinterpret_cast<std::once_flag*>(pFlag);
    std::call_once(flag, [f, p]() { f(p); });
}
#endif

}}}
