﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>
#include <nn/svc/svc_Thread.h>
#include <nn/svc/svc_MemoryMapSelect.h>
#include <nn/os/os_Config.h>


namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------

class AslrSpaceManagerImplByHorizon
{
private:
    static uint64_t GetAslrInfo(svc::InfoType type)
    {
        Bit64 value;
        auto result = svc::GetInfo(&value,
                                   type,
                                   svc::PSEUDO_HANDLE_CURRENT_PROCESS,
                                   0);
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
        NN_SDK_ASSERT(value <= SIZE_MAX);
        return static_cast<uint64_t>(value & SIZE_MAX);
    }

public:
    // ASLR 領域全体
    static uint64_t GetAslrSpaceBeginAddress() NN_NOEXCEPT
    {
        return GetAslrInfo(svc::InfoType_AslrRegionAddress);
    }
    static uint64_t GetAslrSpaceEndAddress() NN_NOEXCEPT
    {
        return GetAslrInfo(svc::InfoType_AslrRegionAddress) + GetAslrInfo(svc::InfoType_AslrRegionSize);
    }

    // ヒープ領域
    static uint64_t GetHeapSpaceBeginAddress() NN_NOEXCEPT
    {
        return GetAslrInfo(svc::InfoType_HeapRegionAddress);
    }
    static uint64_t GetHeapSpaceSize() NN_NOEXCEPT
    {
        return GetAslrInfo(svc::InfoType_HeapRegionSize);
    }

    // 予約領域
    static uint64_t GetReservedSpaceBeginAddress() NN_NOEXCEPT
    {
        return GetAslrInfo(svc::InfoType_ReservedRegionAddress);
    }
    static uint64_t GetReservedSpaceSize() NN_NOEXCEPT
    {
        return GetAslrInfo(svc::InfoType_ReservedRegionSize);
    }
};

typedef AslrSpaceManagerImplByHorizon AslrSpaceManagerImpl;

//--------------------------------------------------------------------------

}  // namespace detail
}} // namespace nn::os

