﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/ncm/ncm_ContentMetaKey.h>

namespace nn { namespace ncm {

    bool ContentMetaKey::operator < (const ContentMetaKey& rhs) const NN_NOEXCEPT
    {
        if (id < rhs.id)
        {
            return true;
        }
        else if (id == rhs.id && version < rhs.version)
        {
            return true;
        }
        else if (id == rhs.id && version == rhs.version && type < rhs.type)
        {
            return true;
        }
        else if (id == rhs.id && version == rhs.version && type == rhs.type && installType < rhs.installType)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    bool ContentMetaKey::operator == (const ContentMetaKey& rhs) const NN_NOEXCEPT
    {
        return id == rhs.id && version == rhs.version && type == rhs.type && installType == rhs.installType;
    }

    bool ContentMetaKey::operator != (const ContentMetaKey& rhs) const NN_NOEXCEPT
    {
        return !operator==(rhs);
    }

    ContentMetaKey ContentMetaKey::Make(SystemProgramId id, uint32_t version) NN_NOEXCEPT
    {
        ContentMetaKey key = {};
        key.type = ContentMetaType::SystemProgram;
        key.id = id.value;
        key.version = version;

        return key;
    }

    ContentMetaKey ContentMetaKey::Make(SystemDataId id, uint32_t version) NN_NOEXCEPT
    {
        ContentMetaKey key = {};
        key.type = ContentMetaType::SystemData;
        key.id = id.value;
        key.version = version;

        return key;
    }

    ContentMetaKey ContentMetaKey::Make(ApplicationId id, uint32_t version) NN_NOEXCEPT
    {
        ContentMetaKey key = {};
        key.type = ContentMetaType::Application;
        key.id = id.value;
        key.version = version;

        return key;
    }

    ContentMetaKey ContentMetaKey::Make(PatchId id, uint32_t version) NN_NOEXCEPT
    {
        ContentMetaKey key = {};
        key.type = ContentMetaType::Patch;
        key.id = id.value;
        key.version = version;

        return key;
    }
    ContentMetaKey ContentMetaKey::Make(PatchId id, uint32_t version, ContentInstallType installType) NN_NOEXCEPT
    {
        ContentMetaKey key = {};
        key.type = ContentMetaType::Patch;
        key.id = id.value;
        key.version = version;
        key.installType = installType;

        return key;
    }
    ContentMetaKey ContentMetaKey::Make(DeltaId id, uint32_t version) NN_NOEXCEPT
    {
        ContentMetaKey key = {};
        key.type = ContentMetaType::Delta;
        key.id = id.value;
        key.version = version;

        return key;
    }

    ContentMetaKey ContentMetaKey::Make(SystemUpdateId id, uint32_t version) NN_NOEXCEPT
    {
        ContentMetaKey key = {};
        key.type = ContentMetaType::SystemUpdate;
        key.id = id.value;
        key.version = version;

        return key;
    }

    ContentMetaKey ContentMetaKey::Make(Bit64 id, uint32_t version, ContentMetaType type) NN_NOEXCEPT
    {
        ContentMetaKey key = { id, version, type};

        return key;
    }
    ContentMetaKey ContentMetaKey::Make(Bit64 id, uint32_t version, ContentMetaType type, ContentInstallType installType) NN_NOEXCEPT
    {
        ContentMetaKey key = { id, version, type, installType};

        return key;
    }


    ContentMetaKey ContentMetaKey::MakeUnknownType(Bit64 id, uint32_t version) NN_NOEXCEPT
    {
        ContentMetaKey key = {};
        key.type = ContentMetaType::Unknown;
        key.id = id;
        key.version = version;

        return key;
    }
}}
