﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Platform_siglo.h"

namespace {
NLIB_ALWAYS_INLINE bool HasNoNullChar(uint32_t x)
{
    return ((x - 0x01010101UL) & 0x80808080UL) == 0 ||
           (((x + 0x7EFEFEFFUL) ^ (~x)) & 0x81010100UL) == 0;
}

}   // namespace

namespace nn {
extern const unsigned char _nlib_popcnt_array[256] = {
    0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
    3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8
};

const void* nlib_memchr(const void* s, int c, size_t n)
{
#if 1
    c = c & 0xFF;
    const unsigned char* ss = reinterpret_cast<const unsigned char*>(s);
    const unsigned char* ss_end = ss + n;
    if (reinterpret_cast<uintptr_t>(ss) & 3) {
        if (ss == ss_end) return NULL;
        if (*ss == c) return ss;
        ++ss;
        if (reinterpret_cast<uintptr_t>(ss) & 3) {
            if (ss == ss_end) return NULL;
            if (*ss == c) return ss;
            ++ss;
            if (reinterpret_cast<uintptr_t>(ss) & 3) {
                if (ss == ss_end) return NULL;
                if (*ss == c) return ss;
                ++ss;
            }
        }
    } else {
        if (!ss) return NULL;
    }
    if (ss == ss_end) return NULL;
    const uint32_t* p = reinterpret_cast<const uint32_t*>(ss);
    const uint32_t* pend = reinterpret_cast<const uint32_t*>(
        reinterpret_cast<uintptr_t>(ss_end) & ~3);
    if (p != pend) {
        uint32_t mask = 0x01010101UL * c;
        do {
            if (NLIB_UNLIKELY(!HasNoNullChar(*p ^ mask))) {
                ss = reinterpret_cast<const unsigned char*>(p);
                if (ss[0] == c) return reinterpret_cast<const char*>(ss);
                if (ss[1] == c) return reinterpret_cast<const char*>(ss) + 1;
                if (ss[2] == c) return reinterpret_cast<const char*>(ss) + 2;
                if (ss[3] == c) return reinterpret_cast<const char*>(ss) + 3;
            }
            ++p;
        } while (p != pend);
    }
    ss = reinterpret_cast<const unsigned char*>(p);
    switch (ss_end - ss) {
    case 0:
        break;
    case 1:
        if (ss[0] == c) return &ss[0];
        break;
    case 2:
        if (ss[0] == c) return &ss[0];
        if (ss[1] == c) return &ss[1];
        break;
    case 3:
        if (ss[0] == c) return &ss[0];
        if (ss[1] == c) return &ss[1];
        if (ss[2] == c) return &ss[2];
        break;
    default:
        NLIB_ASSUME(0);
    }
    return NULL;
#else
    unsigned char uc = static_cast<unsigned char>(c & 0xFF);
    const unsigned char* p = reinterpret_cast<const unsigned char*>(s);
    while (n != 0) {
        --n;
        if (*p == uc) return p;
        ++p;
    }
    return NULL;
#endif
}

const void* nlib_memrchr(const void* s, int c, size_t n)
{
#if 1
    if (n == 0) return NULL;
    c = c & 0xFF;
    const unsigned char* us = reinterpret_cast<const unsigned char*>(s);
    const unsigned char* p = us + n;
    if (reinterpret_cast<uintptr_t>(p) & 3) {
        --p;
        if (*p == c) return reinterpret_cast<const char*>(p);
        if (p == us) return NULL;
        if (reinterpret_cast<uintptr_t>(p) & 3) {
            --p;
            if (*p == c) return reinterpret_cast<const char*>(p);
            if (p == us) return NULL;
            if (reinterpret_cast<uintptr_t>(p) & 3) {
                --p;
                if (*p == c) return reinterpret_cast<const char*>(p);
                if (p == us) return NULL;
            }
        }
    }

    const uint32_t* p32 = reinterpret_cast<const uint32_t*>(p);  // correct
    uint32_t mask = 0x01010101UL * c;
    const unsigned char* ss;
    for (;;) {
STRRCHR_CONTINUE:
        --p32;
        if (reinterpret_cast<const unsigned char*>(p32) < us) {
            break;
        }
        if (!HasNoNullChar(*p32 ^ mask)) goto STRRCHR_CHECK;
    }
    for (p = reinterpret_cast<const unsigned char*>(p32 + 1) - 1; p >= us; --p) {
        if (*p == c) return p;
    }
    return NULL;
STRRCHR_CHECK:
    ss = reinterpret_cast<const unsigned char*>(p32);
    if (ss[3] == c) return reinterpret_cast<const char*>(&ss[3]);
    if (ss[2] == c) return reinterpret_cast<const char*>(&ss[2]);
    if (ss[1] == c) return reinterpret_cast<const char*>(&ss[1]);
    if (ss[0] == c) return reinterpret_cast<const char*>(&ss[0]);
    goto STRRCHR_CONTINUE;
#else
    unsigned char uc = static_cast<unsigned char>(c & 0xFF);
    const unsigned char* p = reinterpret_cast<const unsigned char*>(s);
    p += n;
    while (n != 0) {
        --n;
        --p;
        if (*p == uc) return p;
    }
    return NULL;
#endif
}

}   // namespace nn
