﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/mbuf/mbuf_Definitions.h>

namespace nn { namespace mbuf
{
    enum AllocationSizePolicty
    {
        // 常に要求以上のサイズを割り当てます。
        AllocationSizePolicty_Required,

        // 要求されたサイズの割り当てを必須とはせず、状況に応じて小さいバッファを割り当てます。
        AllocationSizePolicty_NotRequired
    };

    Mbuf* TryAllocate(size_t size, AllocationSizePolicty policy, int type) NN_NOEXCEPT;

    Mbuf* Allocate(size_t size, AllocationSizePolicty policy, int type) NN_NOEXCEPT;

    void Free(Mbuf* pMbuf) NN_NOEXCEPT;

    int GetFreeCountFromPool( int type ) NN_NOEXCEPT;

}} // end of namespace nn::mbuf
