﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>

#include <nn/util/util_StringUtil.h>
#include <nn/lr/lr_Service.h>
#include <nn/lr/lr_ILocationResolverManager.h>
#include <nn/lr/lr_LocationResolverManagerFactory.h>

namespace nn { namespace lr {

    namespace {
        sf::SharedPointer<ILocationResolverManager> g_LocationResolver;
    }

    void Initialize() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(!g_LocationResolver);
        g_LocationResolver = GetLocationResolverManagerService();
    }

    void Finalize() NN_NOEXCEPT
    {
        g_LocationResolver = nullptr;
    }

    Result OpenLocationResolver(LocationResolver* outValue, ncm::StorageId storageId) NN_NOEXCEPT
    {
        sf::SharedPointer<lr::ILocationResolver> locationResolver;
        NN_RESULT_DO(g_LocationResolver->OpenLocationResolver(&locationResolver, static_cast<Bit8>(storageId)));

        *outValue = LocationResolver(std::move(locationResolver));

        NN_RESULT_SUCCESS;
    }

    Result OpenRegisteredLocationResolver(RegisteredLocationResolver* outValue) NN_NOEXCEPT
    {
        sf::SharedPointer<lr::IRegisteredLocationResolver> locationResolver;
        NN_RESULT_DO(g_LocationResolver->OpenRegisteredLocationResolver(&locationResolver));

        *outValue = RegisteredLocationResolver(std::move(locationResolver));

        NN_RESULT_SUCCESS;
    }

    Result OpenAddOnContentLocationResolver(AddOnContentLocationResolver* outValue) NN_NOEXCEPT
    {
        sf::SharedPointer<lr::IAddOnContentLocationResolver> locationResolver;
        NN_RESULT_DO(g_LocationResolver->OpenAddOnContentLocationResolver(&locationResolver));

        *outValue = AddOnContentLocationResolver(std::move(locationResolver));

        NN_RESULT_SUCCESS;
    }

    Result RefreshLocationResolver(ncm::StorageId storageId) NN_NOEXCEPT
    {
        return g_LocationResolver->RefreshLocationResolver(static_cast<Bit8>(storageId));
    }
}}
