﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ldr/ldr_ShellApi.h>
#include <nn/ldr/detail/ldr_ShellInterface.h>

#include <nn/svc/svc_Handle.h>

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ExpHeapAllocator.h>


namespace nn { namespace ldr {

    namespace
    {
        struct AllocatorTag
        {
        };

        typedef nn::sf::ExpHeapStaticAllocator<1024, AllocatorTag> MyAllocator;

        nn::sf::SharedPointer<nn::ldr::detail::IShellInterface> g_RefShellInterface;
        bool g_IsInitialized = false;
    }

    Result InitializeForShell() NN_NOEXCEPT
    {
        NN_SDK_ASSERT( ! g_IsInitialized );

        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);

        Result result = nn::sf::CreateHipcProxyByName<nn::ldr::detail::IShellInterface, MyAllocator::Policy>(
            &g_RefShellInterface, nn::ldr::detail::PortNameForShell);
        if( result.IsSuccess() )
        {
            g_IsInitialized = true;
        }

        return result;
    }

    Result FinalizeForShell() NN_NOEXCEPT
    {
        NN_ABORT("not implemented");
        return ResultSuccess();
    }

    Result SetProgramArgument(ncm::ProgramId programId, const void* pArgument, size_t size) NN_NOEXCEPT
    {
        auto inArgument = nn::sf::InArray<Bit8>(reinterpret_cast<const Bit8*>(pArgument), size);
        return g_RefShellInterface->SetProgramArgument(programId, inArgument, size);
    }

    Result FlushArguments() NN_NOEXCEPT
    {
        return g_RefShellInterface->FlushArguments();
    }

}}
