﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_ContentMetaId.h>")]
    [ExternalStruct(8, 8)]
    public struct ApplicationId
    {
    }

    [CppRefPath(@"<nn/ncm/ncm_DataId.h>")]
    [ExternalStruct(8, 8)]
    public struct DataId
    {
    }

    [CppRefPath(@"<nn/ncm/ncm_ProgramId.h>")]
    [ExternalStruct(8, 8)]
    public struct ProgramId
    {
    }

    [CppRefPath(@"<nn/ncm/ncm_StorageId.h>")]
    [ExternalStruct(1, 1)]
    public struct StorageId
    {
    }
}

namespace nn.spl
{
    [CppRefPath(@"<nn/spl/spl_Types.h>")]
    [ExternalStruct(16, 8)]
    public struct AccessKey
    {
    }
}

namespace nn.fs
{
    [CppRefPath(@"<nn/fs/fs_SaveDataTypes.h>")]
    [ExternalStruct(16, 8)]
    public struct SaveDataMetaInfo
    {
    }

    [CppRefPath(@"<nn/fs/fs_SaveDataTypes.h>")]
    [ExternalStruct(64, 8)]
    public struct SaveDataCreationInfo
    {
    }

    [CppRefPath(@"<nn/fs/fs_SaveDataTypes.h>")]
    [ExternalStruct(64, 8)]
    public struct SaveDataAttribute
    {
    }

    [CppRefPath(@"<nn/fs/fs_SaveDataTypes.h>")]
    [ExternalStruct(72, 8)]
    public struct SaveDataFilter
    {
    }

    [CppRefPath(@"<nn/fs/fs_SaveDataTypes.h>")]
    [ExternalStruct(32, 8)]
    public struct HashSalt
    {
    }

    [CppRefPath(@"<nn/fs/fs_RightsId.h>")]
    [ExternalStruct(16, 8)]
    public struct RightsId
    {
    }

    [CppRefPath(@"<nn/fs/fs_SdCardPrivate.h>")]
    [ExternalStruct(16, 8)]
    public struct EncryptionSeed
    {
    }

    [CppRefPath(@"<nn/fs/fs_ErrorInfoPrivate.h>")]
    [ExternalStruct(128, 8)]
    public struct FileSystemProxyErrorInfo
    {
    }

    [CppRefPath(@"<nn/fs/fs_MemoryReportInfo.h>")]
    [ExternalStruct(128, 8)]
    public struct MemoryReportInfo
    {
    }
}

namespace nn.fssrv.sf
{
    [CppRefPath(@"<nn/fssrv/sf/fssrv_IFileSystemProxy.h>")]
    [LargeData]
    public struct FspPath
    {
        [FixedArray(769)]
        public char_t[] str;
    }

    [CppRefPath(@"<nn/fssrv/sf/fssrv_IFileSystemProxyForLoader.h>")]
    public interface IFileSystemProxyForLoader : IServiceObject
    {
        [MethodId(0)]
        Result OpenCodeFileSystem(Out<IFileSystem> outValue, FspPath path, nn.ncm.ProgramId programId);

        [MethodId(1)]
        Result IsArchivedProgram(Out<bool> outValue, nn.Bit64 processId);

        [MethodId(2)]
        Result SetCurrentProcess([ProcessId] nn.Bit64 processId);
    }

    [CppRefPath(@"<nn/fssrv/sf/fssrv_IFileSystemProxy.h>")]
    public interface IFileSystemProxy : IServiceObject
    {
        // [MethodId(0)] obsolete

        [MethodId(1)]
        Result SetCurrentProcess([ProcessId] nn.Bit64 processId);

        [MethodId(2)]
        Result OpenDataFileSystemByCurrentProcess(Out<IFileSystem> outValue);

        // [MethodId(3)] obsolete
        // [MethodId(4)] obsolete
        // [MethodId(5)] obsolete
        // [MethodId(6)] obsolete

        [MethodId(7)]
        Result OpenFileSystemWithPatch(Out<IFileSystem> outValue, nn.ncm.ProgramId programId, uint32_t type);

        [MethodId(8)]
        Result OpenFileSystemWithId(Out<IFileSystem> outValue, FspPath path, nn.Bit64 programId, uint32_t type);

        [MethodId(9)]
        Result OpenDataFileSystemByProgramId(Out<IFileSystem> outValue, nn.ncm.ProgramId programId);

        [MethodId(11)]
        Result OpenBisFileSystem(Out<IFileSystem> outValue, FspPath path, uint32_t id);

        [MethodId(12)]
        Result OpenBisStorage(Out<IStorage> outValue, uint32_t id);

        [MethodId(13)]
        Result InvalidateBisCache();

        [MethodId(17)]
        Result OpenHostFileSystem(Out<IFileSystem> outValue, FspPath path);

        [MethodId(18)]
        Result OpenSdCardFileSystem(Out<IFileSystem> outValue);

        [MethodId(19)]
        Result FormatSdCardFileSystem();

        // [MethodId(20)] obsolete

        [MethodId(21)]
        Result DeleteSaveDataFileSystem(uint64_t saveDataId);

        [MethodId(22)]
        Result CreateSaveDataFileSystem(nn.fs.SaveDataAttribute attribute, nn.fs.SaveDataCreationInfo creationInfo, nn.fs.SaveDataMetaInfo metaInfo);

        [MethodId(23)]
        Result CreateSaveDataFileSystemBySystemSaveDataId(nn.fs.SaveDataAttribute attribute, nn.fs.SaveDataCreationInfo creationInfo);

        [MethodId(24)]
        Result RegisterSaveDataFileSystemAtomicDeletion(InBuffer saveDataIdArray);

        [MethodId(25)]
        Result DeleteSaveDataFileSystemBySaveDataSpaceId(uint8_t saveDataSpaceId, uint64_t saveDataId);

        [MethodId(26)]
        Result FormatSdCardDryRun();

        [MethodId(27)]
        Result IsExFatSupported(Out<bool> outValue);

        [MethodId(28)]
        Result DeleteSaveDataFileSystemBySaveDataAttribute(uint8_t saveDataSpaceId, nn.fs.SaveDataAttribute attribute);

        [MethodId(30)]
        Result OpenGameCardStorage(Out<IStorage> outValue, uint32_t handle, uint32_t partition);

        [MethodId(31)]
        Result OpenGameCardFileSystem(Out<IFileSystem> outValue, uint32_t handle, uint32_t partition);

        [MethodId(32)]
        Result ExtendSaveDataFileSystem(uint8_t spaceId, uint64_t saveDataId, int64_t saveDataAvailableSize, int64_t saveDataJournalSize);

        [MethodId(33)]
        Result DeleteCacheStorage(uint16_t index);

        [MethodId(34)]
        Result GetCacheStorageSize(Out<int64_t> outSize, Out<int64_t> outJournalSize, uint16_t index);

        [MethodId(35)]
        Result CreateSaveDataFileSystemWithHashSalt(nn.fs.SaveDataAttribute attribute, nn.fs.SaveDataCreationInfo creationInfo, nn.fs.SaveDataMetaInfo metaInfo, nn.fs.HashSalt salt);
        // [MethodId(50)] obsolete

        [MethodId(51)]
        Result OpenSaveDataFileSystem(Out<IFileSystem> outValue, uint8_t saveDataSpaceId, nn.fs.SaveDataAttribute attribute);

        [MethodId(52)]
        Result OpenSaveDataFileSystemBySystemSaveDataId(Out<IFileSystem> outValue, uint8_t saveDataSpaceId, nn.fs.SaveDataAttribute attribute);

        [MethodId(53)]
        Result OpenReadOnlySaveDataFileSystem(Out<IFileSystem> outValue, uint8_t saveDataSpaceId, nn.fs.SaveDataAttribute attribute);

        [MethodId(57)]
        Result ReadSaveDataFileSystemExtraDataBySaveDataSpaceId(OutBuffer buffer, uint8_t saveDataSpaceId, uint64_t saveDataId);

        [MethodId(58)]
        Result ReadSaveDataFileSystemExtraData(OutBuffer buffer, uint64_t saveDataId);

        [MethodId(59)]
        Result WriteSaveDataFileSystemExtraData(uint64_t saveDataId, uint8_t saveDataSpaceId, InBuffer buffer);

        [MethodId(60)]
        Result OpenSaveDataInfoReader(Out<ISaveDataInfoReader> outValue);

        [MethodId(61)]
        Result OpenSaveDataInfoReaderBySaveDataSpaceId(Out<ISaveDataInfoReader> outValue, uint8_t saveDataSpaceId);

        [MethodId(62)]
        Result OpenSaveDataInfoReaderOnlyCacheStorage(Out<ISaveDataInfoReader> outValue);


        // [MethodId(62)] obsolete
        // [MethodId(63)] obsolete

        [MethodId(64)]
        Result OpenSaveDataInternalStorageFileSystem(Out<IFileSystem> outValue, uint8_t saveDataSpaceId, uint64_t saveDataId);

        [MethodId(65)]
        Result UpdateSaveDataMacForDebug(uint8_t saveDataSpaceId, uint64_t saveDataId);

        [MethodId(66)]
        Result WriteSaveDataFileSystemExtraDataWithMask(uint64_t saveDataId, uint8_t saveDataSpaceId, InBuffer extraDataValue, InBuffer extraDataMask);

        [MethodId(67)]
        Result FindSaveDataWithFilter(Out<int64_t> outValue, OutBuffer buffer, uint8_t saveDataSpaceId, nn.fs.SaveDataFilter filter);

        [MethodId(68)]
        Result OpenSaveDataInfoReaderWithFilter(Out<ISaveDataInfoReader> outValue, uint8_t saveDataSpaceId, nn.fs.SaveDataFilter filter);

        [MethodId(80)]
        Result OpenSaveDataMetaFile(Out<IFile> outValue, uint8_t saveDataSpaceId, nn.fs.SaveDataAttribute attribute, uint32_t metaType);

        [MethodId(81)]
        Result OpenSaveDataTransferManager(Out<ISaveDataTransferManager> outValue);

        [MethodId(82)]
        Result OpenSaveDataTransferManagerVersion2(Out<ISaveDataTransferManagerWithDivision> outValue);

        [MethodId(83)]
        Result OpenSaveDataTransferProhibiter(Out<ISaveDataTransferProhibiter> outValue, nn.ncm.ApplicationId applicationId);

        [MethodId(84)]
        Result ListAccessibleSaveDataOwnerId(Out<int32_t> outValue, OutBuffer outBuffer, nn.ncm.ProgramId programId, int offset, int count);

        [MethodId(100)]
        Result OpenImageDirectoryFileSystem(Out<IFileSystem> outValue, uint32_t storageId);

        [MethodId(110)]
        Result OpenContentStorageFileSystem(Out<IFileSystem> outValue, uint32_t storageId);

        [MethodId(120)]
        Result OpenCloudBackupWorkStorageFileSystem(Out<IFileSystem> outValue, uint32_t storageId);

        [MethodId(200)]
        Result OpenDataStorageByCurrentProcess(Out<IStorage> outValue);

        [MethodId(201)]
        Result OpenDataStorageByProgramId(Out<IStorage> outValue, nn.ncm.ProgramId programId);

        [MethodId(202)]
        Result OpenDataStorageByDataId(Out<IStorage> outValue, nn.ncm.DataId dataId, nn.Bit8 storageId);

        [MethodId(203)]
        Result OpenPatchDataStorageByCurrentProcess(Out<IStorage> outValue);

        [MethodId(400)]
        Result OpenDeviceOperator(Out<IDeviceOperator> outValue);

        [MethodId(500)]
        Result OpenSdCardDetectionEventNotifier(Out<IEventNotifier> outValue);

        [MethodId(501)]
        Result OpenGameCardDetectionEventNotifier(Out<IEventNotifier> outValue);

        [MethodId(510)]
        Result OpenSystemDataUpdateEventNotifier(Out<IEventNotifier> outValue);

        [MethodId(511)]
        Result NotifySystemDataUpdateEvent();

        [MethodId(520)]
        Result SimulateDeviceDetectionEvent(uint32_t deviceType, uint32_t detectionEventType, bool isWithEvent);

        // [MethodId(600)] obsolete

        [MethodId(601)]
        Result QuerySaveDataTotalSize(Out<int64_t> outValue, int64_t saveDataSize, int64_t saveDataJournalSize);

        [MethodId(602)]
        Result VerifySaveDataFileSystem(uint64_t saveDataId, OutBuffer buffer);

        [MethodId(603)]
        Result CorruptSaveDataFileSystem(uint64_t saveDataId);

        [MethodId(604)]
        Result CreatePaddingFile(int64_t paddingSize);

        [MethodId(605)]
        Result DeleteAllPaddingFiles();

        [MethodId(606)]
        Result GetRightsId(Out<nn.fs.RightsId> outValue, nn.ncm.ProgramId programId, nn.ncm.StorageId storageId);

        [MethodId(607)]
        Result RegisterExternalKey(nn.fs.RightsId rightsId, nn.spl.AccessKey accessKey);

        [MethodId(608)]
        Result UnregisterAllExternalKey();

        [MethodId(609)]
        Result GetRightsIdByPath(Out<nn.fs.RightsId> outValue, FspPath path);

        [MethodId(610)]
        Result GetRightsIdAndKeyGenerationByPath(Out<nn.fs.RightsId> outRightsId, Out<uint8_t> outKeyGeneration, FspPath path);

        [MethodId(611)]
        Result SetCurrentPosixTimeWithTimeDifference(int64_t posixTime, int32_t timeDifference);

        [MethodId(612)]
        Result GetFreeSpaceSizeForSaveData(Out<int64_t> outValue, uint8_t saveDataSpaceId);

        [MethodId(613)]
        Result VerifySaveDataFileSystemBySaveDataSpaceId(uint8_t saveDataSpaceId, uint64_t saveDataId, OutBuffer buffer);

        [MethodId(614)]
        Result CorruptSaveDataFileSystemBySaveDataSpaceId(uint8_t saveDataSpaceId, uint64_t saveDataId);

        [MethodId(615)]
        Result QuerySaveDataInternalStorageTotalSize(Out<int64_t> outValue, uint8_t saveDataSpaceId, uint64_t saveDataId);

        [MethodId(616)]
        Result GetSaveDataCommitId(Out<int64_t> outValue, uint8_t saveDataSpaceId, uint64_t saveDataId);

        [MethodId(620)]
        Result SetSdCardEncryptionSeed(nn.fs.EncryptionSeed seed);

        [MethodId(630)]
        Result SetSdCardAccessibility(bool isAccessible);

        [MethodId(631)]
        Result IsSdCardAccessible(Out<bool> outValue);

        [MethodId(640)]
        Result IsSignedSystemPartitionOnSdCardValid(Out<bool> outValue);

        [MethodId(700)]
        Result OpenAccessFailureDetectionEventNotifier(Out<IEventNotifier> outValue, nn.Bit64 processId);

        [MethodId(701)]
        Result GetAccessFailureDetectionEvent(Out<NativeHandle> outValue);

        [MethodId(702)]
        Result IsAccessFailureDetected(Out<bool> outValue, nn.Bit64 processId);

        [MethodId(710)]
        Result ResolveAccessFailure(nn.Bit64 processId);

        [MethodId(720)]
        Result AbandonAccessFailure(nn.Bit64 processId);

        [MethodId(800)]
        Result GetAndClearErrorInfo(Out<nn.fs.FileSystemProxyErrorInfo> outValue);

        [MethodId(1000)]
        Result SetBisRootForHost(uint32_t id, FspPath path);

        [MethodId(1001)]
        Result SetSaveDataSize(int64_t size, int64_t journalSize);

        [MethodId(1002)]
        Result SetSaveDataRootPath(FspPath path);

        [MethodId(1003)]
        Result DisableAutoSaveDataCreation();

        [MethodId(1004)]
        Result SetGlobalAccessLogMode(uint32_t accessLogMode);

        [MethodId(1005)]
        Result GetGlobalAccessLogMode(Out<uint32_t> outValue);

        [MethodId(1006)]
        Result OutputAccessLogToSdCard(InBuffer buffer);

        [MethodId(1007)]
        Result RegisterUpdatePartition();

        [MethodId(1008)]
        Result OpenRegisteredUpdatePartition(Out<IFileSystem> outValue);

        [MethodId(1009)]
        Result GetAndClearMemoryReportInfo(Out<nn.fs.MemoryReportInfo> outValue);

        [MethodId(1010)]
        Result SetDataStorageRedirectTarget(nn.ncm.StorageId storageId);

        [MethodId(1100)]
        Result OverrideSaveDataTransferTokenSignVerificationKey(InBuffer buffer);

        [MethodId(1200)]
        Result OpenMultiCommitManager(Out<IMultiCommitManager> outValue);

    }

}
