﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/fssrv/fssrv_SaveDataInfoFilter.h>
#include "detail/fssrv_Trace.h"

namespace nn { namespace fssrv {

    Result SaveDataInfoFilterReader::Read(nn::sf::Out<std::int64_t> outValue, const nn::sf::OutBuffer& outEntries) NN_NOEXCEPT
    {
        NN_FS_SCOPED_TRACE("%p", m_Reader.get());

        NN_FS_SCOPED_TRACE_CAPTURE_RESULT
        {
            auto infoBuffer = reinterpret_cast<nn::fs::SaveDataInfo*>(outEntries.GetPointerUnsafe());
            int64_t restCount = outEntries.GetSize() / sizeof(nn::fs::SaveDataInfo);
            int64_t count = 0;
            nn::fs::SaveDataInfo info;
            while (restCount > 0)
            {
                int64_t outCount = 0;
                NN_RESULT_DO(m_Reader->Read(nn::sf::Out<int64_t>(&outCount), nn::sf::OutBuffer(reinterpret_cast<char*>(&info), sizeof(nn::fs::SaveDataInfo))));
                if (outCount == 0)
                {
                    break;
                }
                if (!m_Filter.Includes(info))
                {
                    continue;
                }

                infoBuffer[count] = info;
                --restCount;
                count++;
            }

            outValue.Set(count);
            NN_RESULT_SUCCESS;
        }
        NN_FS_SCOPED_TRACE_END_CAPTURE_RESULT
    }

}}
