﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fssystem/fs_NcaFileSystemDriver.h>

namespace {

    const unsigned char HeaderSign1KeyModulusDev[] =
    {
        0xd8, 0xf1, 0x18, 0xef, 0x32, 0x72, 0x4c, 0xa7, 0x47, 0x4c, 0xb9, 0xea, 0xb3, 0x04, 0xa8, 0xa4,
        0xac, 0x99, 0x08, 0x08, 0x04, 0xbf, 0x68, 0x57, 0xb8, 0x43, 0x94, 0x2b, 0xc7, 0xb9, 0x66, 0x49,
        0x85, 0xe5, 0x8a, 0x9b, 0xc1, 0x00, 0x9a, 0x6a, 0x8d, 0xd0, 0xef, 0xce, 0xff, 0x86, 0xc8, 0x5c,
        0x5d, 0xe9, 0x53, 0x7b, 0x19, 0x2a, 0xa8, 0xc0, 0x22, 0xd1, 0xf3, 0x22, 0x0a, 0x50, 0xf2, 0x2b,
        0x65, 0x05, 0x1b, 0x9e, 0xec, 0x61, 0xb5, 0x63, 0xa3, 0x6f, 0x3b, 0xba, 0x63, 0x3a, 0x53, 0xf4,
        0x49, 0x2f, 0xcf, 0x03, 0xcc, 0xd7, 0x50, 0x82, 0x1b, 0x29, 0x4f, 0x08, 0xde, 0x1b, 0x6d, 0x47,
        0x4f, 0xa8, 0xb6, 0x6a, 0x26, 0xa0, 0x83, 0x3f, 0x1a, 0xaf, 0x83, 0x8f, 0x0e, 0x17, 0x3f, 0xfe,
        0x44, 0x1c, 0x56, 0x94, 0x2e, 0x49, 0x83, 0x83, 0x03, 0xe9, 0xb6, 0xad, 0xd5, 0xde, 0xe3, 0x2d,
        0xa1, 0xd9, 0x66, 0x20, 0x5d, 0x1f, 0x5e, 0x96, 0x5d, 0x5b, 0x55, 0x0d, 0xd4, 0xb4, 0x77, 0x6e,
        0xae, 0x1b, 0x69, 0xf3, 0xa6, 0x61, 0x0e, 0x51, 0x62, 0x39, 0x28, 0x63, 0x75, 0x76, 0xbf, 0xb0,
        0xd2, 0x22, 0xef, 0x98, 0x25, 0x02, 0x05, 0xc0, 0xd7, 0x6a, 0x06, 0x2c, 0xa5, 0xd8, 0x5a, 0x9d,
        0x7a, 0xa4, 0x21, 0x55, 0x9f, 0xf9, 0x3e, 0xbf, 0x16, 0xf6, 0x07, 0xc2, 0xb9, 0x6e, 0x87, 0x9e,
        0xb5, 0x1c, 0xbe, 0x97, 0xfa, 0x82, 0x7e, 0xed, 0x30, 0xd4, 0x66, 0x3f, 0xde, 0xd8, 0x1b, 0x4b,
        0x15, 0xd9, 0xfb, 0x2f, 0x50, 0xf0, 0x9d, 0x1d, 0x52, 0x4c, 0x1c, 0x4d, 0x8d, 0xae, 0x85, 0x1e,
        0xea, 0x7f, 0x86, 0xf3, 0x0b, 0x7b, 0x87, 0x81, 0x98, 0x23, 0x80, 0x63, 0x4f, 0x2f, 0xb0, 0x62,
        0xcc, 0x6e, 0xd2, 0x46, 0x13, 0x65, 0x2b, 0xd6, 0x44, 0x33, 0x59, 0xb5, 0x8f, 0xb9, 0x4a, 0xa9,
    };

    const unsigned char HeaderSign1KeyModulusProd[] =
    {
        0xbf, 0xbe, 0x40, 0x6c, 0xf4, 0xa7, 0x80, 0xe9, 0xf0, 0x7d, 0x0c, 0x99, 0x61, 0x1d, 0x77, 0x2f,
        0x96, 0xbc, 0x4b, 0x9e, 0x58, 0x38, 0x1b, 0x03, 0xab, 0xb1, 0x75, 0x49, 0x9f, 0x2b, 0x4d, 0x58,
        0x34, 0xb0, 0x05, 0xa3, 0x75, 0x22, 0xbe, 0x1a, 0x3f, 0x03, 0x73, 0xac, 0x70, 0x68, 0xd1, 0x16,
        0xb9, 0x04, 0x46, 0x5e, 0xb7, 0x07, 0x91, 0x2f, 0x07, 0x8b, 0x26, 0xde, 0xf6, 0x00, 0x07, 0xb2,
        0xb4, 0x51, 0xf8, 0x0d, 0x0a, 0x5e, 0x58, 0xad, 0xeb, 0xbc, 0x9a, 0xd6, 0x49, 0xb9, 0x64, 0xef,
        0xa7, 0x82, 0xb5, 0xcf, 0x6d, 0x70, 0x13, 0xb0, 0x0f, 0x85, 0xf6, 0xa9, 0x08, 0xaa, 0x4d, 0x67,
        0x66, 0x87, 0xfa, 0x89, 0xff, 0x75, 0x90, 0x18, 0x1e, 0x6b, 0x3d, 0xe9, 0x8a, 0x68, 0xc9, 0x26,
        0x04, 0xd9, 0x80, 0xce, 0x3f, 0x5e, 0x92, 0xce, 0x01, 0xff, 0x06, 0x3b, 0xf2, 0xc1, 0xa9, 0x0c,
        0xce, 0x02, 0x6f, 0x16, 0xbc, 0x92, 0x42, 0x0a, 0x41, 0x64, 0xcd, 0x52, 0xb6, 0x34, 0x4d, 0xae,
        0xc0, 0x2e, 0xde, 0xa4, 0xdf, 0x27, 0x68, 0x3c, 0xc1, 0xa0, 0x60, 0xad, 0x43, 0xf3, 0xfc, 0x86,
        0xc1, 0x3e, 0x6c, 0x46, 0xf7, 0x7c, 0x29, 0x9f, 0xfa, 0xfd, 0xf0, 0xe3, 0xce, 0x64, 0xe7, 0x35,
        0xf2, 0xf6, 0x56, 0x56, 0x6f, 0x6d, 0xf1, 0xe2, 0x42, 0xb0, 0x83, 0x40, 0xa5, 0xc3, 0x20, 0x2b,
        0xcc, 0x9a, 0xae, 0xca, 0xed, 0x4d, 0x70, 0x30, 0xa8, 0x70, 0x1c, 0x70, 0xfd, 0x13, 0x63, 0x29,
        0x02, 0x79, 0xea, 0xd2, 0xa7, 0xaf, 0x35, 0x28, 0x32, 0x1c, 0x7b, 0xe6, 0x2f, 0x1a, 0xaa, 0x40,
        0x7e, 0x32, 0x8c, 0x27, 0x42, 0xfe, 0x82, 0x78, 0xec, 0x0d, 0xeb, 0xe6, 0x83, 0x4b, 0x6d, 0x81,
        0x04, 0x40, 0x1a, 0x9e, 0x9a, 0x67, 0xf6, 0x72, 0x29, 0xfa, 0x04, 0xf0, 0x9d, 0xe4, 0xf4, 0x03
    };

    nn::fssystem::NcaCryptoConfiguration g_NcaCryptoConfigurationPublicPreSet1 =
    {
        { // headerSign1KeyModulus
            0x00,
        },

        { // headerSign1KeyPublicExponent
            0x01, 0x00, 0x01
        },

        // keyAreaEncryptionKeySource
        {
            { 0x00, }, // appli
            { 0x00, }, // ocean: private
            { 0x00, }, // system: private
        },

        // headerEncryptionKeySource
        { 0x0 },

        // headerEncryptedEncryptionKey
        {
            { 0x5a, 0x3e, 0xd8, 0x4f, 0xde, 0xc0, 0xd8, 0x26, 0x31, 0xf7, 0xe2, 0x5d, 0x19, 0x7b, 0xf5, 0xd0, },
            { 0x1c, 0x9b, 0x7b, 0xfa, 0xf6, 0x28, 0x18, 0x3d, 0x71, 0xf6, 0x4d, 0x73, 0xf1, 0x50, 0xb9, 0xd2, },
        },

        nullptr,
    };

}


namespace nn { namespace fssrv {

const nn::fssystem::NcaCryptoConfiguration* GetNcaDefaultCryptoConfiguration(bool isProd)
{
    const unsigned char* const pHeaderSign1KeyModulus = isProd ? HeaderSign1KeyModulusProd
                                                               : HeaderSign1KeyModulusDev;
    memcpy(g_NcaCryptoConfigurationPublicPreSet1.headerSign1KeyModulus, pHeaderSign1KeyModulus, sizeof(g_NcaCryptoConfigurationPublicPreSet1.headerSign1KeyModulus));
    return &g_NcaCryptoConfigurationPublicPreSet1;
}

}}

