﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace fssrv { namespace detail {

    template <typename T>
    class SharedLock
    {
    public:
        explicit SharedLock(T& mutex)
            : m_pMutex(&mutex)
        {
            m_pMutex->lock_shared();
        }
        ~SharedLock()
        {
            m_pMutex->unlock_shared();
        }

    private:
        T* m_pMutex;
    };

}}}
