﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "fssrv_RuntimeConfiguration.h"

namespace nn { namespace fssrv { namespace detail {

    namespace {
        bool g_IsEnabledProgramVerification = true;
    }

    void SetEnabledProgramVerification(bool isEnabled) NN_NOEXCEPT
    {
        // pm によってプロセス起動時 1 度だけ呼び出されることを想定しているためロックはとらない
        g_IsEnabledProgramVerification = isEnabled;
    }

    bool GetEnabledProgramVerification() NN_NOEXCEPT
    {
        return g_IsEnabledProgramVerification;
    }

    // Storage Redirection
    namespace {
        nn::ncm::StorageId g_DataStorageRedirectTarget = nn::ncm::StorageId::None;
    }

    void SetDataStorageRedirectTarget(nn::ncm::StorageId storageId) NN_NOEXCEPT
    {
        // DevMenuCommand のみから呼び出される想定であるためロックはとらない
        g_DataStorageRedirectTarget = storageId;
    }

    nn::ncm::StorageId GetDataStorageRedirectTarget() NN_NOEXCEPT
    {
        return g_DataStorageRedirectTarget;
    }

}}}
