﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <new>
#include <type_traits>
#include <nn/nn_Abort.h>
#include <nn/os/os_Mutex.h>
#include <nn/fs/detail/fs_ServerName.h>
#include <nn/fssrv/detail/fssrv_FileSystemProxyServiceObject.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/impl/sf_StaticOneAllocator.h>

#include <nn/fssrv/fssrv_FileSystemProxyImpl.h>
#include <nn/fssrv/fssrv_ProgramRegistryImpl.h>
#include "fssrv_AllocatorForServiceFrameWork.h"

namespace nn { namespace fssrv { namespace detail {

    namespace {
#if defined(NN_BUILD_CONFIG_OS_WIN32)
        typedef nn::sf::ObjectFactory<nn::sf::impl::StaticOneAllocationPolicy> FileSystemProxyServiceFactory;
        typedef nn::sf::ObjectFactory<nn::sf::impl::StaticOneAllocationPolicy> FileSystemProxyForLoaderServiceFactory;
#else
        typedef nn::sf::ObjectFactory<AllocatorForServiceFrameWork::Policy> FileSystemProxyServiceFactory;
        typedef nn::sf::ObjectFactory<AllocatorForServiceFrameWork::Policy> FileSystemProxyForLoaderServiceFactory;
#endif
        typedef nn::sf::ObjectFactory<AllocatorForServiceFrameWork::Policy> ProgramRegistryServiceFactory;
    }

    nn::sf::EmplacedRef<nn::fssrv::sf::IFileSystemProxy, nn::fssrv::FileSystemProxyImpl> GetFileSystemProxyServiceObject() NN_NOEXCEPT
    {
        return FileSystemProxyServiceFactory::CreateSharedEmplaced<nn::fssrv::sf::IFileSystemProxy, nn::fssrv::FileSystemProxyImpl>();
    }

    nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxyForLoader> GetFileSystemProxyForLoaderServiceObject() NN_NOEXCEPT
    {
        return FileSystemProxyForLoaderServiceFactory::CreateSharedEmplaced<nn::fssrv::sf::IFileSystemProxyForLoader, nn::fssrv::FileSystemProxyImpl>();
    }

    nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxyForLoader> GetInvalidFileSystemProxyForLoaderServiceObject() NN_NOEXCEPT
    {
        return FileSystemProxyForLoaderServiceFactory::CreateSharedEmplaced<nn::fssrv::sf::IFileSystemProxyForLoader, nn::fssrv::InvalidFileSystemProxyImplForLoader>();
    }

    nn::sf::SharedPointer<nn::fssrv::sf::IProgramRegistry> GetProgramRegistryServiceObject() NN_NOEXCEPT
    {
        return ProgramRegistryServiceFactory::CreateSharedEmplaced<nn::fssrv::sf::IProgramRegistry, nn::fssrv::ProgramRegistryImpl>();
    }

    nn::sf::SharedPointer<nn::fssrv::sf::IProgramRegistry> GetInvalidProgramRegistryServiceObject() NN_NOEXCEPT
    {
        return ProgramRegistryServiceFactory::CreateSharedEmplaced<nn::fssrv::sf::IProgramRegistry, nn::fssrv::InvalidProgramRegistryImpl>();
    }

}}}
