﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/detail/fs_Newable.h>
#include <nn/fssrv/sf/fssrv_IEventNotifier.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/util/util_IntrusiveList.h>

namespace nn { namespace fssrv { namespace detail {

    class DeviceDetectionEventManager;
    class DeviceDetectionEventNotifier : public nn::util::IntrusiveListBaseNode<DeviceDetectionEventNotifier>, public nn::fs::detail::Newable
    {
    public:
        NN_IMPLICIT DeviceDetectionEventNotifier(DeviceDetectionEventManager* pManager) NN_NOEXCEPT;
        ~DeviceDetectionEventNotifier() NN_NOEXCEPT;

        Result GetEventHandle(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
        nn::os::SystemEventType* GetEvent() NN_NOEXCEPT;

    private:
        nn::os::SystemEventType m_SystemEvent;
        DeviceDetectionEventManager* m_Manager;
    };

}}}
