﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_SdkLog.h>

#include "fssrv_AccessFailureDetectionEventManager.h"
#include "fssrv_AccessFailureDetectionEventNotifier.h"

namespace nn { namespace fssrv { namespace detail {

    AccessFailureDetectionEventNotifier::AccessFailureDetectionEventNotifier(AccessFailureDetectionEventManager* pManager, Bit64 processId) NN_NOEXCEPT : m_SystemEvent(util::nullopt), m_Manager(pManager), m_ProcessId(processId), m_State(State::None)
    {
    }

    AccessFailureDetectionEventNotifier::~AccessFailureDetectionEventNotifier() NN_NOEXCEPT
    {
        if (m_SystemEvent != util::nullopt)
        {
            os::DestroySystemEvent(&(m_SystemEvent.value()));
        }
        m_Manager->DeleteNotifier(this);
    }

    Result AccessFailureDetectionEventNotifier::GetEventHandle(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    {
        m_SystemEvent.emplace();
        NN_RESULT_DO(os::CreateSystemEvent(&(m_SystemEvent.value()), os::EventClearMode_ManualClear, true));

        auto handle = os::GetReadableHandleOfSystemEvent(&(m_SystemEvent.value()));
        outValue.Set(nn::sf::NativeHandle(handle, false));

        NN_RESULT_SUCCESS;
    }

    bool AccessFailureDetectionEventNotifier::IsInitialized() NN_NOEXCEPT
    {
        return m_SystemEvent != util::nullopt;
    }

    os::SystemEventType* AccessFailureDetectionEventNotifier::GetEvent() NN_NOEXCEPT
    {
        if (m_SystemEvent == util::nullopt)
        {
            return nullptr;
        }
        return &(m_SystemEvent.value());
    }

    Bit64 AccessFailureDetectionEventNotifier::GetProcessId() NN_NOEXCEPT
    {
        return m_ProcessId;
    }

    AccessFailureDetectionEventNotifier::State AccessFailureDetectionEventNotifier::GetState() NN_NOEXCEPT
    {
        return m_State;
    }

    void AccessFailureDetectionEventNotifier::SetState(AccessFailureDetectionEventNotifier::State state) NN_NOEXCEPT
    {
        m_State = state;
    }

}}}
