﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/detail/fs_AccessLog.h>
#include <nn/fs/detail/fs_Data.h>
#include <nn/fs/detail/fs_ResultHandlingUtility.h>
#include <nn/ncm/ncm_SystemContentMetaId.h>
#include <nn/ncm/ncm_StorageId.h>

namespace nn { namespace fs {

Result QueryMountSystemDataCacheSize(size_t* pOutValue, nn::ncm::SystemDataId dataId) NN_NOEXCEPT
{
    NN_FS_RESULT_DO(NN_DETAIL_FS_ACCESS_LOG_SYSTEM(detail::QueryMountDataCacheSize(pOutValue, dataId, nn::ncm::StorageId::BuildInSystem),
        nullptr, NN_DETAIL_FS_ACCESS_LOG_FORMAT_SYSTEMDATAID NN_DETAIL_FS_ACCESS_LOG_FORMAT_QUERY_SIZE, dataId, detail::ReferenceQuerySizeOutValue(pOutValue)));
    NN_RESULT_SUCCESS;
}

Result MountSystemData(const char* name, nn::ncm::SystemDataId dataId) NN_NOEXCEPT
{
    NN_FS_RESULT_DO(NN_DETAIL_FS_ACCESS_LOG_SYSTEM_MOUNT(detail::MountData(name, dataId, nn::ncm::StorageId::BuildInSystem), name, NN_DETAIL_FS_ACCESS_LOG_FORMAT_MOUNTSYSTEMDATA(name, dataId)));
    NN_DETAIL_FS_ACCESS_LOG_SYSTEM_FSACCESSOR_ENABLE(name);
    NN_RESULT_SUCCESS;
}

Result MountSystemData(
    const char* name,
    nn::ncm::SystemDataId dataId,
    void* pFileSystemCacheBuffer,
    size_t fileSystemCacheBufferSize
) NN_NOEXCEPT
{
    NN_FS_RESULT_DO(NN_DETAIL_FS_ACCESS_LOG_SYSTEM_MOUNT(detail::MountData(
        name, dataId, nn::ncm::StorageId::BuildInSystem, pFileSystemCacheBuffer, fileSystemCacheBufferSize
    ), name, NN_DETAIL_FS_ACCESS_LOG_FORMAT_MOUNTSYSTEMDATA(name, dataId)));
    NN_DETAIL_FS_ACCESS_LOG_SYSTEM_FSACCESSOR_ENABLE(name);
    NN_RESULT_SUCCESS;
}

}}
